<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

function remove_from_admin_bar($wp_admin_bar) {
    /*
     * Placing items in here will only remove them from admin bar
     * when viewing the fronte end of the site
    */
    if ( ! is_admin() ) {
        // Example of removing item generated by plugin. Full ID is #wp-admin-bar-si_menu
        $wp_admin_bar->remove_node('si_menu');
 
        // WordPress Core Items (uncomment to remove)
        $wp_admin_bar->remove_node('updates');
        $wp_admin_bar->remove_node('comments');
        $wp_admin_bar->remove_node('new-content');
        //$wp_admin_bar->remove_node('wp-logo');
        //$wp_admin_bar->remove_node('site-name');
        //$wp_admin_bar->remove_node('my-account');
        $wp_admin_bar->remove_node('admin.php?page=dokan');
        $wp_admin_bar->remove_node('post-new.php');
        $wp_admin_bar->remove_node('customize');
    }
 
    /*
     * Items placed outside the if statement will remove it from both the frontend
     * and backend of the site
    */
    $wp_admin_bar->remove_node('wp-logo');
    $wp_admin_bar->remove_node('page=dokan#');
}
add_action('admin_bar_menu', 'remove_from_admin_bar', 999);

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

$user_id = get_current_user_id();
if ($user_id == 5) { //em 10, adicione o ID do usuário que deseja remover os itens do menu

 function remove_menus(){

 //remove_menu_page( 'index.php' ); //Dashboard 
 remove_menu_page( 'edit.php' ); //Posts - publicações
 //remove_menu_page( 'upload.php' ); //Media - imagens, vídeos, docs, etc...
 //remove_menu_page( 'edit.php?post_type=page' ); //Pages - páginas
 //remove_menu_page( 'edit-comments.php' ); //Comments - comentários
 remove_menu_page( 'themes.php' ); //Appearance - aparência (recomendo!)
 remove_menu_page( 'plugins.php' ); //Plugins (recomendo!)
 //remove_menu_page( 'users.php' ); //Users - usuários 
 remove_menu_page( 'tools.php' ); //Tools - ferramentas (recomendo!)
 remove_menu_page( 'options-general.php' ); //Settings - configurações 
 remove_menu_page( 'admin.php?page=loco' ); //revolution slider, se estiver instalado
 remove_menu_page( 'edit.php?post_type=fl-builder-template&fl-builder-template-type=layout' ); //revolution slider, se estiver instalado
 
 }
 add_action( 'admin_menu', 'remove_menus' );
 
} else {}