(function ($) {

	"use strict";

	// Variables
	var content_container 	= '#main.site-main';
	var post_title_selector = 'h1.entry-title';
	var nav_container 		= 'nav.post-navigation';
	var comments_container 	= 'div#comments';
	var remove_comments     = 'yes';
	var track_pageviews     = 'yes';
	var curr_url            = window.location.href;
	var post_count          = 0;
	var stop_reading        = false;
	var show_comments       = astra.show_comments || 'Show Comments';
	var edit_post_url		= astra.edit_post_url || '';
	var siteUrl		    	= astra.site_url || '';

	$( document ).ready( function() {
	
		var in_customizer = false;

		// check for wp.customize return boolean
		if ( typeof wp !== 'undefined' ) {
			in_customizer =  typeof wp.customize !== 'undefined' ? true : false;
		}

		// Don't do this if looking for comments or in customizer.
		if ( in_customizer || window.location.href.indexOf( '#comments' ) > -1 ) {
			return;
		}

		// Remove Comments.
		if ( remove_comments === 'yes' ) {
			
			initialise_comment( comments_container );
		}

		var temp_content_container = $( content_container );
		var post_ID = temp_content_container.find('.ast-article-single').attr('id');

		if ( typeof post_ID !== typeof undefined && post_ID !== "" ) {
			post_ID = post_ID.replace('post-', '');
		}

		// Add a post divider.
		temp_content_container.prepend( '<hr style="height: 0" class="post-divider" data-title="' + window.document.title + '" data-url="' + window.location.href + '" data-post-id="' + post_ID + '"/>' );

		// Initialise scrollSpy
		initialise_scrollspy();

		$('body').on( 'click', '.ast-show-comments', function( e ) {
			console.log( $(this) );
			var parent = $(this).closest('.ast-show-comments-data');
			parent.hide();
			parent.siblings().show();
		});
		
		
		$('body').on( 'astra-enter', function( e ) {
			console.log('Entering new post');
		});

		$('body').on( 'astra-leaving', function( e ) {
			console.log('Leaving post');
		});

		/**
		 * Track Page View with Google Analytics.
		 *
		 * It will first detect if Google Analytics is installed before
		 * attempting to send a pageview.
		 *
		 * The tracker detects both classic and universal tracking methods.
		 *
		 * Also supports Google Analytics by Monster Insights should it be used.
		 */
		$('body').on( 'asta-post-changed', function( e, post_title, post_url, post_id, post_count, stop_reading ) {
			if ( track_pageviews != 'yes' ) {
				return;
			}

			console.log( 'Google Analytics Tracking Enabled' );

			if ( typeof pageTracker === "undefined" && typeof _gaq === 'undefined' && typeof ga === 'undefined' && typeof __gaTracker === 'undefined' ) {
				console.log( 'Google Analytics was not found installed on your site!' );
				return;
			}

			// Remove the base URL from the post_url.
			var regexp = new RegExp(siteUrl, 'gi')
			var postUrl = post_url.replace(regexp, '');

			console.log( 'Track: ' + postUrl );

			// This uses Asynchronous version of Google Analytics tracking method.
			if ( typeof pageTracker !== "undefined" && pageTracker !== null ) {
				console.log( 'Google Analytics is installed, but old.' );
				pageTracker._trackPageview( postUrl );
			}

			// This uses Google's classic Google Analytics tracking method.
			if ( typeof _gaq !== 'undefined' && _gaq !== null ) {
				console.log( 'Google Analytics is installed. Yahoo!' );
				_gaq.push(['_trackPageview', postUrl]);
			}

			// This uses Google Analytics Universal Analytics tracking method.
			if ( typeof ga !== 'undefined' && ga !== null ) {
				console.log( 'Google Analytics Universal Analytics is installed. Yahoo!' );
				ga( 'send', 'pageview', postUrl );
			}

			// This uses Monster Insights method of tracking Google Analytics.
			if ( typeof __gaTracker !== 'undefined' && __gaTracker !== null ) {
				console.log( 'Google Analytics by Yoast is installed. Awesome!' );
				__gaTracker( 'send', 'pageview', postUrl );
			}

			// This uses Google Analytics Universal Analytics tracking method.
			if ( typeof gtag !== 'undefined' && gtag !== null ) {
				gtag('event', 'page_view', {
				  'page_title' : post_title,
				  'page_path': postUrl
				});
			}
			
		});

	}); // END document()
	
	function initialise_comment( comments_wrapper ) {
		
		var $comments_container 	= $( comments_wrapper );
		
		if (  0 === $comments_container.length ) {
			return;
		}

		$comments_container.each(function( index ) {
			
			var $this = $(this);

			if ( $this.find('.ast-show-comments-data').length === 0  ) {
				var comments_count_wrapper 	= $this.find( '.comments-count-wrapper' );
				var show_comment_title 		= '';
				
				$this.find( '.comment-respond' ).hide();

				var comment_data = '<div class="ast-show-comments-data">';

				if ( comments_count_wrapper.length > 0 ) {
					comments_count_wrapper.hide();
					$this.find( '.ast-comment-list' ).hide();

					comment_data += '<div class="ast-show-comments-count"><h3 class="comments-title">' + comments_count_wrapper.find('.comments-title').text() + '</h3></div>';
				}
				
				comment_data += '<div class="ast-show-comments button ast-button">' + show_comments + '</div>';
				
				comment_data += '</div>';

				$this.find( '.no-comments' ).hide();

				$this.prepend( comment_data );
			}
		});
	}
	
	function initialise_scrollspy() {
		scrollspy();
	} // END initialise_scrollspy()

	function scrollspy( disable ) {
		
		$( '.post-divider').off( 'scrollSpy:enter', astra_enter );
		$( '.post-divider').off( 'scrollSpy:exit', astra_leave );

		// Spy on post-divider - changes the URL in browser location and loads new post.
		$( '.post-divider').on( 'scrollSpy:enter', astra_enter );
		$( '.post-divider').on( 'scrollSpy:exit', astra_leave );
		$( '.post-divider').scrollSpy();
	} // END scrollspy()

	function astra_enter() {
		var $enter = $(this);

		$('body').trigger( 'astra-enter', [ $enter ] );

		changeURL($enter, 'enter' );
	} // END astra_enter()

	function astra_leave() {
		var $leave = $(this);

		$('body').trigger( 'astra-leave', [ $leave ] );

		changeURL($leave, 'leave' );
	} // END astra_leave()

	function changeURL( $this, in_out_style ) {
		var el           = $($this);
		var this_url     = el.attr( 'data-url' );
		var this_title   = el.attr( 'data-title' );
		var this_post_id = el.attr( 'data-post-id' );
		var offset       = el.offset();
		var scrollTop    = $(document).scrollTop();


		//ast-article-single
		
		// console.log( in_out_style );
		// console.log( el );
		// console.log( offset );
		// console.log( scrollTop );

		if ( 'leave' === in_out_style ) {
			console.log( el.prev( '.post-divider' ) );
		}

		// If exiting or entering from top, change URL.
		if ( ( offset.top - scrollTop ) < 200 && curr_url != this_url ) {
			curr_url = this_url;
			History.pushState(null, this_title, this_url);

			// Update edit link if possible
			if( $('#wp-admin-bar-edit').length > 0 && '' != edit_post_url ) {

				var new_edit_post_url = edit_post_url.replace( "{{id}}", this_post_id ); 
				
				$('#wp-admin-bar-edit a').attr( 'href', new_edit_post_url );
			}
			$('body').trigger( 'asta-post-changed', [ this_title, this_url, this_post_id, post_count, stop_reading ] );
		}

		if ( el.nextAll( '.post-divider' ).length === 0 ) {
			// Look for the next post to load if any.
			auto_load_next_post();
		}
	} // END changeURL()

	/**
	 * This is the main function.
	 */
	function auto_load_next_post() {
		// If the user can no read any more then stop looking for new posts.
		if ( stop_reading ) {
			return;
		}

		// Grab the url for the next post in the post navigation.
		var post_url = $( nav_container ).find( 'a[rel="prev"]').attr( 'href' );
		
		// Override the post url via a trigger.
		$('body').trigger( 'astra-post-url', [ post_count, post_url ] );

		// console.log( 'post_url' );
		// console.log( post_url );
		//console.log( typeof post_url !== 'undefined' );
		// For some browsers, `post_url` is undefined; for others,
		// `post_url` is false. So we check for both possibilites.
		// if ( typeof post_url !== 'undefined' && post_url !== false ) {
		// 	console.log( 'Post URL was defined. Next Post URL: ' + post_url );
		// } else {
		// 	console.error( 'Post URL was not defined. Oh dear!' );
		// }

		if ( !post_url ) return;

		// Check to see if pretty permalinks, if not then add partial-prev=1
		if ( post_url.indexOf( '?' ) > -1 ) {
			var np_url = post_url + '&partial-prev=1'
		} else {
			var np_url = post_url + '?partial-prev=1'
			// var partial_endpoint = 'partial-prev/';

			// if ( post_url.charAt(post_url.length - 1) != '/' )
			// 	partial_endpoint = '/' + partial_endpoint;

			// var np_url = post_url + partial_endpoint;
		}

		// Remove the post navigation HTML once the next post has loaded.
		$( nav_container ).remove();
		// if ( $( nav_container ).length <= 0 ) {
		// 	console.log( 'Post Navigation Removed!' );
		// }
		
		console.log( np_url );

		$.get( np_url , function( data ) {

			var post = $( "<div>" + data + "</div>" );

			// Allows the post data to be modified before being appended.
			$('body').trigger( 'astra-post-data', [ post ] );

			data = post.html(); // Returns the HTML data of the next post that was loaded.

			var post_divider = '<hr style="height: 0" class="ast-single-previous-hr post-divider" data-url="' + post_url + '"/>';
			var post_html    = $( post_divider + data );
			var post_title   = post_html.find( post_title_selector ); // Find the post title of the loaded article.
			var post_ID      = $(post).find( 'article' ).attr( 'id' ); // Find the post ID of the loaded article.

			if ( typeof post_ID !== typeof undefined && post_ID !== "" ) {
				post_ID = post_ID.replace('post-', ''); // Make sure that only the post ID remains.
				//console.log( 'Post ID: ' + post_ID + ' was found.' );
			} else {
				//console.error( 'Post ID was not found.' );
			}

			console.log( 'Post Title: ' + post_title.text() ); // Console Log Post Title

			$( content_container ).append( post_html ); // Add next post.

			// Remove Comments.
			if ( remove_comments === 'yes' ) {

				initialise_comment( comments_container );

				//$( comments_container ).remove();
				// if ( $( comments_container ).length <= 0 ) {
				// 	console.log( 'Comments Removed' );
				// }
			}

			// Get the hidden "HR" element and add the missing post title and post id attributes. Also make sure it remains hidden.
			$( 'hr[data-url="' + post_url + '"]').attr( 'data-title' , post_title.text() ).attr( 'data-post-id' , post_ID );// .css( 'display', 'inline-block' );

			scrollspy(); // Need to set up ScrollSpy now that the new content has loaded.

			post_count = post_count+1; // Updates the post count.
			console.log('Post Count: ' + post_count);

			// Run an event once the post has loaded.
			$('body').trigger( 'astra-post-loaded', [ post_title.text(), post_url, post_ID, post_count ] );
		});

	} // END auto_load_next_post()


})(jQuery);