/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-08-14 21:15:50 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wptj_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=622 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wptj_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wptj_comments */
INSERT INTO `wptj_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2019-05-22 22:48:34", "2019-05-22 22:48:34", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: wptj_duplicator_packages */
INSERT INTO `wptj_duplicator_packages` VALUES("2", "20190612_dmk", "b23c67b27d23a0e56571_20190814211537", "21", "2019-08-14 21:15:50", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-14 21:15:37\";s:7:\"Version\";s:6:\"1.3.14\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.6.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:12:\"20190612_dmk\";s:4:\"Hash\";s:35:\"b23c67b27d23a0e56571_20190814211537\";s:8:\"NameHash\";s:48:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"/home/klestersrfcom/public_html/dmk/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"https://siterapidofacil.com/dmk/wp-snapshots/\";s:8:\"ScanFile\";s:58:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";d:21;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:60:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/home/klestersrfcom/public_html/dmk\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-14 21:15:37\";s:7:\"Version\";s:6:\"1.3.14\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.6.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:12:\"20190612_dmk\";s:4:\"Hash\";s:35:\"b23c67b27d23a0e56571_20190814211537\";s:8:\"NameHash\";s:48:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"/home/klestersrfcom/public_html/dmk/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"https://siterapidofacil.com/dmk/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:62:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:61:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:16:\"wptj_commentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:114:\"/home/klestersrfcom/public_html/dmk/wp-snapshots/tmp/20190612_dmk_b23c67b27d23a0e56571_20190814211537_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:44:\"/home/klestersrfcom/public_html/dmk/wp-admin\";i:1;s:54:\"/home/klestersrfcom/public_html/dmk/wp-content/uploads\";i:2;s:56:\"/home/klestersrfcom/public_html/dmk/wp-content/languages\";i:3;s:53:\"/home/klestersrfcom/public_html/dmk/wp-content/themes\";i:4;s:47:\"/home/klestersrfcom/public_html/dmk/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:35:\"/home/klestersrfcom/public_html/dmk\";i:1;s:46:\"/home/klestersrfcom/public_html/dmk/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:130;}");

/* INSERT TABLE DATA: wptj_options */
INSERT INTO `wptj_options` VALUES("1", "siteurl", "https://siterapidofacil.com/dmk", "yes");
INSERT INTO `wptj_options` VALUES("2", "home", "https://siterapidofacil.com/dmk", "yes");
INSERT INTO `wptj_options` VALUES("3", "blogname", "DMK", "yes");
INSERT INTO `wptj_options` VALUES("4", "blogdescription", "Madeira Florestal", "yes");
INSERT INTO `wptj_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wptj_options` VALUES("6", "admin_email", "klecinho.ar@gmail.com", "yes");
INSERT INTO `wptj_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wptj_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wptj_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wptj_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wptj_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wptj_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wptj_options` VALUES("13", "rss_use_excerpt", "1", "yes");
INSERT INTO `wptj_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wptj_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wptj_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wptj_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wptj_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wptj_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wptj_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wptj_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wptj_options` VALUES("22", "posts_per_page", "5", "yes");
INSERT INTO `wptj_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wptj_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wptj_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wptj_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wptj_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wptj_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wptj_options` VALUES("29", "rewrite_rules", "a:159:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:46:\"category/(.+?)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:55:\"index.php?category_name=$matches[1]&flpaged=$matches[2]\";s:43:\"tag/([^/]+)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:45:\"index.php?tag=$matches[1]&flpaged=$matches[2]\";s:42:\"([0-9]{4})/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:46:\"index.php?year=$matches[1]&flpaged=$matches[2]\";s:55:\"([0-9]{4})/([0-9]{1,2})/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:67:\"index.php?year=$matches[1]&monthnum=$matches[2]&flpaged=$matches[3]\";s:68:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:83:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&flpaged=$matches[4]\";s:46:\"author/([^/]+)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:53:\"index.php?author_name=$matches[1]&flpaged=$matches[2]\";s:40:\"([0-9]+)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:43:\"index.php?p=$matches[1]&flpaged=$matches[2]\";s:39:\"(.?.+?)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:50:\"index.php?pagename=$matches[1]&flpaged=$matches[2]\";s:37:\"(.+?)/paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:46:\"index.php?name=$matches[1]&flpaged=$matches[2]\";s:26:\"paged-[0-9]{1,}/([0-9]*)/?\";s:39:\"index.php?page_id=5&flpaged=$matches[1]\";s:31:\"paged-[0-9]{1,}/?([0-9]{1,})/?$\";s:30:\"index.php?&flpaged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"fl-builder-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"fl-builder-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"fl-builder-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"fl-builder-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"fl-builder-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"fl-builder-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"fl-builder-template/([^/]+)/embed/?$\";s:52:\"index.php?fl-builder-template=$matches[1]&embed=true\";s:40:\"fl-builder-template/([^/]+)/trackback/?$\";s:46:\"index.php?fl-builder-template=$matches[1]&tb=1\";s:48:\"fl-builder-template/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?fl-builder-template=$matches[1]&paged=$matches[2]\";s:55:\"fl-builder-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?fl-builder-template=$matches[1]&cpage=$matches[2]\";s:44:\"fl-builder-template/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?fl-builder-template=$matches[1]&page=$matches[2]\";s:36:\"fl-builder-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"fl-builder-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"fl-builder-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"fl-builder-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"fl-builder-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"fl-builder-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:69:\"fl-builder-template-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?fl-builder-template-category=$matches[1]&feed=$matches[2]\";s:64:\"fl-builder-template-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?fl-builder-template-category=$matches[1]&feed=$matches[2]\";s:45:\"fl-builder-template-category/([^/]+)/embed/?$\";s:61:\"index.php?fl-builder-template-category=$matches[1]&embed=true\";s:57:\"fl-builder-template-category/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?fl-builder-template-category=$matches[1]&paged=$matches[2]\";s:39:\"fl-builder-template-category/([^/]+)/?$\";s:50:\"index.php?fl-builder-template-category=$matches[1]\";s:65:\"fl-builder-template-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?fl-builder-template-type=$matches[1]&feed=$matches[2]\";s:60:\"fl-builder-template-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?fl-builder-template-type=$matches[1]&feed=$matches[2]\";s:41:\"fl-builder-template-type/([^/]+)/embed/?$\";s:57:\"index.php?fl-builder-template-type=$matches[1]&embed=true\";s:53:\"fl-builder-template-type/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?fl-builder-template-type=$matches[1]&paged=$matches[2]\";s:35:\"fl-builder-template-type/([^/]+)/?$\";s:46:\"index.php?fl-builder-template-type=$matches[1]\";s:47:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"astra-advanced-hook/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"astra-advanced-hook/([^/]+)/embed/?$\";s:52:\"index.php?astra-advanced-hook=$matches[1]&embed=true\";s:40:\"astra-advanced-hook/([^/]+)/trackback/?$\";s:46:\"index.php?astra-advanced-hook=$matches[1]&tb=1\";s:48:\"astra-advanced-hook/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?astra-advanced-hook=$matches[1]&paged=$matches[2]\";s:55:\"astra-advanced-hook/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?astra-advanced-hook=$matches[1]&cpage=$matches[2]\";s:44:\"astra-advanced-hook/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?astra-advanced-hook=$matches[1]&page=$matches[2]\";s:36:\"astra-advanced-hook/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"astra-advanced-hook/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"astra-advanced-hook/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"astra-advanced-hook/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"astra-advanced-hook/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"astra-advanced-hook/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"astra_adv_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"astra_adv_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"astra_adv_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"astra_adv_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"astra_adv_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"astra_adv_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"astra_adv_header/([^/]+)/embed/?$\";s:49:\"index.php?astra_adv_header=$matches[1]&embed=true\";s:37:\"astra_adv_header/([^/]+)/trackback/?$\";s:43:\"index.php?astra_adv_header=$matches[1]&tb=1\";s:45:\"astra_adv_header/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?astra_adv_header=$matches[1]&paged=$matches[2]\";s:52:\"astra_adv_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?astra_adv_header=$matches[1]&cpage=$matches[2]\";s:41:\"astra_adv_header/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?astra_adv_header=$matches[1]&page=$matches[2]\";s:33:\"astra_adv_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"astra_adv_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"astra_adv_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"astra_adv_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"astra_adv_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"astra_adv_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=5&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wptj_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wptj_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wptj_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wptj_options` VALUES("33", "active_plugins", "a:7:{i:0;s:27:\"astra-addon/astra-addon.php\";i:1;s:27:\"astra-sites/astra-sites.php\";i:2;s:37:\"bb-header-footer/bb-header-footer.php\";i:3;s:24:\"bb-plugin/fl-builder.php\";i:4;s:39:\"bb-ultimate-addon/bb-ultimate-addon.php\";i:5;s:28:\"bbpowerpack/bb-powerpack.php\";i:6;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `wptj_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wptj_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wptj_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wptj_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wptj_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wptj_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wptj_options` VALUES("40", "template", "astra", "yes");
INSERT INTO `wptj_options` VALUES("41", "stylesheet", "astra-child", "yes");
INSERT INTO `wptj_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wptj_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wptj_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wptj_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wptj_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wptj_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wptj_options` VALUES("48", "db_version", "44719", "yes");
INSERT INTO `wptj_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wptj_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wptj_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wptj_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wptj_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wptj_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wptj_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wptj_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wptj_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wptj_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wptj_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wptj_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wptj_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wptj_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wptj_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wptj_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wptj_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wptj_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wptj_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wptj_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wptj_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wptj_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wptj_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wptj_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wptj_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wptj_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wptj_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wptj_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wptj_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("81", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wptj_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wptj_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wptj_options` VALUES("84", "page_on_front", "5", "yes");
INSERT INTO `wptj_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wptj_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wptj_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wptj_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wptj_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wptj_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wptj_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wptj_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wptj_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `wptj_options` VALUES("94", "wptj_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wptj_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wptj_options` VALUES("96", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("97", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("98", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("99", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("100", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("101", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wptj_options` VALUES("102", "cron", "a:6:{i:1565819314;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1565822914;a:4:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1565822942;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1565822947;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1565990049;a:1:{s:30:\"fl_builder_notifications_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wptj_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wptj_options` VALUES("146", "astra-settings", "a:7:{s:18:\"theme-auto-version\";s:5:\"1.8.4\";s:24:\"astra-addon-auto-version\";s:5:\"1.8.2\";s:19:\"above-header-layout\";s:21:\"above-header-layout-1\";s:27:\"above-header-section-1-html\";s:46:\"Fone (81) 3117-3500 — E-mail: dmk@dmk.com.br\";s:22:\"above-header-section-2\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";s:3:\"122\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"display-site-title\";b:0;}", "yes");
INSERT INTO `wptj_options` VALUES("149", "astra-theme-old-setup", "1", "yes");
INSERT INTO `wptj_options` VALUES("153", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("205", "fl_notifications", "a:3:{s:4:\"read\";b:1;s:8:\"checksum\";a:10:{i:455558;i:1112446375;i:434899;i:569945551;i:430933;i:2949435807;i:423877;i:1545241705;i:421774;i:3087814018;i:416381;i:3671926234;i:408945;i:2968285658;i:404849;i:308115498;i:375859;i:1690867192;i:352086;i:1712285855;}s:4:\"data\";s:19700:\"[{\"id\":455558,\"date\":\"2019-04-30T15:21:14\",\"date_gmt\":\"2019-04-30T22:21:14\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=455558\"},\"modified\":\"2019-04-30T15:21:14\",\"modified_gmt\":\"2019-04-30T22:21:14\",\"slug\":\"spring-update-cherry-blossoms-new-hires-and-new-products\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=spring-update-cherry-blossoms-new-hires-and-new-products\",\"title\":{\"rendered\":\"Spring Update \\u2013 Cherry Blossoms, New Hires, and New Products\"},\"content\":{\"rendered\":\"\\n<div class=\\\"wp-block-image\\\"><figure class=\\\"aligncenter\\\"><img src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/04\\/spring-update-notification.jpg\\\" alt=\\\"\\\" class=\\\"wp-image-455560\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/04\\/spring-update-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/04\\/spring-update-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/figure><\\/div>\\n\\n\\n\\n<p>Hey all! Happy Spring. The Beaver Builder team continues to grow and I\\u2019m excited to introduce two new members. We\\u2019re also growing our product line, and we have recently announced a very early version of a new project we\\u2019ve been working on, Assistant.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/spring-update-cherry-blossoms-new-hires-and-new-products\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/455558\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=455558\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":434899,\"date\":\"2019-02-22T00:04:57\",\"date_gmt\":\"2019-02-22T08:04:57\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=434899\"},\"modified\":\"2019-02-22T00:05:00\",\"modified_gmt\":\"2019-02-22T08:05:00\",\"slug\":\"3-reasons-why-wordpress-agencies-love-beaver-builder\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=3-reasons-why-wordpress-agencies-love-beaver-builder\",\"title\":{\"rendered\":\"3 Reasons Why WordPress Agencies Love Beaver Builder\"},\"content\":{\"rendered\":\"\\n<div class=\\\"wp-block-image\\\"><figure class=\\\"aligncenter\\\"><img src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/why-agencies-love-bb-notification.jpg\\\" alt=\\\"\\\" class=\\\"wp-image-434901\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/why-agencies-love-bb-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/why-agencies-love-bb-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/figure><\\/div>\\n\\n\\n\\n<p>Ever wonder why the biggest companies and agencies in the WordPress space choose Beaver Builder? Companies like Crowd Favorite, GoDaddy, and WP Engine? In this <g class=\\\"gr_ gr_44 gr-alert gr_gramm gr_inline_cards gr_run_anim Punctuation only-ins replaceWithoutSep\\\" id=\\\"44\\\" data-gr-id=\\\"44\\\">article<\\/g> we discuss three reasons why agencies \\u2764\\ufe0f Beaver Builder!<br><\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/3-reasons-why-wordpress-agencies-love-beaver-builder\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/434899\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=434899\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":430933,\"date\":\"2019-02-08T12:10:12\",\"date_gmt\":\"2019-02-08T20:10:12\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=430933\"},\"modified\":\"2019-02-08T12:10:15\",\"modified_gmt\":\"2019-02-08T20:10:15\",\"slug\":\"winter-update-blocks-in-beaver-builder-future-plans-and-more\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=winter-update-blocks-in-beaver-builder-future-plans-and-more\",\"title\":{\"rendered\":\"Winter Update \\u2013 Blocks in Beaver Builder, Future Plans, and More\"},\"content\":{\"rendered\":\"\\n<div class=\\\"wp-block-image\\\"><figure class=\\\"aligncenter\\\"><img src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/winter-update-notification.jpg\\\" alt=\\\"\\\" class=\\\"wp-image-430941\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/winter-update-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/02\\/winter-update-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/figure><\\/div>\\n\\n\\n\\n<p>Our latest update post is live. We have news about future plans for Beaver Builder and an upcoming module overhaul! Our plugs and footnotes section is well stocked this time around. We\'ve been jumping on a ton of podcasts recently talking about everything from the future of\\u00a0Beaver Builder to digital nomadism! Let\'s get into it\\u2026<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/winter-update-blocks-future-plans-and-more\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/430933\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=430933\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":423877,\"date\":\"2019-01-16T15:51:14\",\"date_gmt\":\"2019-01-16T23:51:14\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=423877\"},\"modified\":\"2019-01-16T15:51:14\",\"modified_gmt\":\"2019-01-16T23:51:14\",\"slug\":\"difference-between-gutenberg-and-page-builders-like-beaver-builder-elementor-and-divi\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=difference-between-gutenberg-and-page-builders-like-beaver-builder-elementor-and-divi\",\"title\":{\"rendered\":\"Difference between Gutenberg and Page Builders like Beaver Builder, Elementor, and Divi\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-423885\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/gutenberg-vs-bb-notification.jpg\\\" alt=\\\"Difference between Gutenberg and Beaver Builder\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/gutenberg-vs-bb-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/gutenberg-vs-bb-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>This question has been coming up a lot! In this post, we explain how page builders differ from Gutenberg and the best scenarios to understand when to use one or the other. This might be old news to\\u00a0Beaver Builder users like you, but if you have a client or a friend that is trying to grok the differences this is the post for them.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/difference-between-gutenberg-and-page-builders-like-beaver-builder-elementor-and-divi\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/423877\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=423877\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":421774,\"date\":\"2019-01-09T10:34:00\",\"date_gmt\":\"2019-01-09T18:34:00\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=421774\"},\"modified\":\"2019-01-09T10:34:00\",\"modified_gmt\":\"2019-01-09T18:34:00\",\"slug\":\"mental-health-stress-and-burnout-an-interview-with-dr-sherry-walling\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=mental-health-stress-and-burnout-an-interview-with-dr-sherry-walling\",\"title\":{\"rendered\":\"Mental Health, Stress, and Burnout \\u2013 An interview with Dr. Sherry Walling\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-421777\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/sherry-walling-notification.jpg\\\" alt=\\\"Mental health, stress, and burnout\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/sherry-walling-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2019\\/01\\/sherry-walling-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>We met Dr. Sherry Walling several years ago at an event and were extremely impressed with her candid discussions about mental health in the entrepreneurial space. I am thrilled that she agreed to work with us on an interview-style blog post discussing some practical ways to improve one\'s mental and emotional wellbeing.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/mental-health-stress-and-burnout-an-interview-with-dr-sherry-walling\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/421774\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=421774\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":416381,\"date\":\"2018-12-14T09:02:44\",\"date_gmt\":\"2018-12-14T17:02:44\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=416381\"},\"modified\":\"2018-12-14T09:02:44\",\"modified_gmt\":\"2018-12-14T17:02:44\",\"slug\":\"thoughts-on-gutenberg-and-a-wordcamp-us-recap\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=thoughts-on-gutenberg-and-a-wordcamp-us-recap\",\"title\":{\"rendered\":\"Thoughts on Gutenberg and a WordCamp US Recap\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-416382\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/12\\/wcus-notification.jpg\\\" alt=\\\"\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/12\\/wcus-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/12\\/wcus-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>A few of us from the Beaver Builder team had the opportunity to attend WordCamp US 2018 in Nashville, Tennessee, this week. I\'d like to try something new this year and write down a few thoughts about the event and share photos.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/thoughts-on-gutenberg-and-a-wordcamp-us-recap\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/416381\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=416381\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":408945,\"date\":\"2018-11-23T15:19:24\",\"date_gmt\":\"2018-11-23T23:19:24\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=408945\"},\"modified\":\"2018-11-23T15:20:13\",\"modified_gmt\":\"2018-11-23T23:20:13\",\"slug\":\"black-friday-cyber-monday-25-off-everything\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=black-friday-cyber-monday-25-off-everything\",\"title\":{\"rendered\":\"Black Friday \\/ Cyber Monday \\u2013 25% Off Everything\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-408954\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/black-friday-notification.jpg\\\" alt=\\\"\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/black-friday-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/black-friday-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>Happy Turkey Week! We\'re excited to continue our tradition of offering up a major discount on\\u00a0Beaver Builder for Black Friday and Cyber Monday 2018. Don\'t miss out on this limited time offer.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/black-friday-cyber-monday-2018-25-off-everything\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/408945\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=408945\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":404849,\"date\":\"2018-11-08T13:34:29\",\"date_gmt\":\"2018-11-08T21:34:29\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=404849\"},\"modified\":\"2018-11-08T13:34:29\",\"modified_gmt\":\"2018-11-08T21:34:29\",\"slug\":\"autumn-update-addressing-all-the-elephants\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=autumn-update-addressing-all-the-elephants\",\"title\":{\"rendered\":\"Autumn Update \\u2013 Addressing all the Elephants\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-404853\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/autumn-update-notification.jpg\\\" alt=\\\"\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/autumn-update-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/11\\/autumn-update-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>Why, hello there! It\'s an exciting time in the WordPress world with Gutenberg on the verge of going live. We have a bunch of exciting news to share and new features to announce. Find out more in our Autumn update.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/autumn-update-addressing-all-the-elephants\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/404849\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=404849\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":375859,\"date\":\"2018-07-11T12:30:14\",\"date_gmt\":\"2018-07-11T19:30:14\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=375859\"},\"modified\":\"2018-07-11T12:30:14\",\"modified_gmt\":\"2018-07-11T19:30:14\",\"slug\":\"summer-update-sneak-peaks-new-features-and-more\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=summer-update-sneak-peaks-new-features-and-more\",\"title\":{\"rendered\":\"Summer Update \\u2013 Sneak Peaks, New Features, and More\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-375874\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/07\\/bb-summer-2018.jpg\\\" alt=\\\"\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/07\\/bb-summer-2018.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/07\\/bb-summer-2018-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>Hope you\'re having a great summer! We have updates and alpha versions across the board\\u2014Page Builder, Beaver Themer, and the BB Theme are all getting some exciting new features and enhancements.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/summer-update-sneak-peaks-new-features-and-more\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/375859\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=375859\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":352086,\"date\":\"2018-04-26T11:28:42\",\"date_gmt\":\"2018-04-26T18:28:42\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?post_type=fl_notification&#038;p=352086\"},\"modified\":\"2018-04-26T11:28:42\",\"modified_gmt\":\"2018-04-26T18:28:42\",\"slug\":\"happy-4th-birthday-to-beaver-builder\",\"status\":\"publish\",\"type\":\"fl_notification\",\"link\":\"https:\\/\\/www.wpbeaverbuilder.com\\/?fl_notification=happy-4th-birthday-to-beaver-builder\",\"title\":{\"rendered\":\"Happy 4th Birthday to Beaver Builder\"},\"content\":{\"rendered\":\"<p><img class=\\\"aligncenter size-full wp-image-352087\\\" src=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/04\\/bday-notification.jpg\\\" alt=\\\"\\\" width=\\\"318\\\" height=\\\"139\\\" srcset=\\\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/04\\/bday-notification.jpg 318w, https:\\/\\/www.wpbeaverbuilder.com\\/wp-content\\/uploads\\/2018\\/04\\/bday-notification-300x131.jpg 300w\\\" sizes=\\\"(max-width: 318px) 100vw, 318px\\\" \\/><\\/p>\\n<p>For the last few years, we\\u2019ve made a point to celebrate our birthday here at\\u00a0Beaver Builder. It\\u2019s hard to believe, since starting this journey from client work to products, a whole four years have gone by.<\\/p>\\n\",\"protected\":false},\"template\":\"\",\"meta\":{\"_fl_notification\":[\"https:\\/\\/www.wpbeaverbuilder.com\\/happy-4th-birthday-to-beaver-builder\\/\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\\/352086\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/fl_notification\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/types\\/fl_notification\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpbeaverbuilder.com\\/wp-json\\/wp\\/v2\\/media?parent=352086\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}}]\";}", "yes");
INSERT INTO `wptj_options` VALUES("113", "theme_mods_twentynineteen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1558565667;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wptj_options` VALUES("114", "WPLANG", "pt_BR", "yes");
INSERT INTO `wptj_options` VALUES("139", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("143", "current_theme", "Astra Child", "yes");
INSERT INTO `wptj_options` VALUES("144", "theme_mods_astra-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:49;}", "yes");
INSERT INTO `wptj_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `wptj_options` VALUES("606", "_site_transient_timeout_theme_roots", "1565818982", "no");
INSERT INTO `wptj_options` VALUES("607", "_site_transient_theme_roots", "a:2:{s:11:\"astra-child\";s:7:\"/themes\";s:5:\"astra\";s:7:\"/themes\";}", "no");
INSERT INTO `wptj_options` VALUES("603", "_transient_timeout_bsf_check_product_updates", "1565989979", "no");
INSERT INTO `wptj_options` VALUES("604", "_transient_bsf_check_product_updates", "1", "no");
INSERT INTO `wptj_options` VALUES("610", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-5.2.2.zip\";s:6:\"locale\";s:5:\"pt_BR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-5.2.2.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.2\";s:7:\"version\";s:5:\"5.2.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1565817187;s:15:\"version_checked\";s:5:\"5.2.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wptj_options` VALUES("124", "can_compress_scripts", "0", "no");
INSERT INTO `wptj_options` VALUES("444", "fl_builder_usage_enabled", "0", "no");
INSERT INTO `wptj_options` VALUES("611", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1565817188;s:7:\"checked\";a:2:{s:11:\"astra-child\";s:5:\"1.0.0\";s:5:\"astra\";s:5:\"1.8.4\";}s:8:\"response\";a:1:{s:5:\"astra\";a:6:{s:5:\"theme\";s:5:\"astra\";s:11:\"new_version\";s:5:\"1.8.7\";s:3:\"url\";s:35:\"https://wordpress.org/themes/astra/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/theme/astra.1.8.7.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";b:0;}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wptj_options` VALUES("612", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1565817192;s:8:\"response\";a:6:{s:27:\"astra-sites/astra-sites.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/astra-sites\";s:4:\"slug\";s:11:\"astra-sites\";s:6:\"plugin\";s:27:\"astra-sites/astra-sites.php\";s:11:\"new_version\";s:6:\"1.3.17\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/astra-sites/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/astra-sites.1.3.17.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/astra-sites/assets/icon-256x256.jpg?rev=1712437\";s:2:\"1x\";s:64:\"https://ps.w.org/astra-sites/assets/icon-128x128.jpg?rev=1712437\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/astra-sites/assets/banner-1544x500.jpg?rev=1712437\";s:2:\"1x\";s:66:\"https://ps.w.org/astra-sites/assets/banner-772x250.jpg?rev=1712437\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.3.18\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.3.18.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2083921\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2083921\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:6:\"5.2.17\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:24:\"bb-plugin/fl-builder.php\";O:8:\"stdClass\":8:{s:4:\"slug\";s:9:\"bb-plugin\";s:6:\"plugin\";s:24:\"bb-plugin/fl-builder.php\";s:11:\"new_version\";s:7:\"2.2.4.3\";s:3:\"url\";s:30:\"http://www.wpbeaverbuilder.com\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"5.2.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://siterapidofacil.com/dmk/wp-content/plugins/bb-plugin/img/beaver-128.png\";s:2:\"2x\";s:79:\"https://siterapidofacil.com/dmk/wp-content/plugins/bb-plugin/img/beaver-256.png\";s:7:\"default\";s:79:\"https://siterapidofacil.com/dmk/wp-content/plugins/bb-plugin/img/beaver-256.png\";}s:14:\"upgrade_notice\";s:80:\"Insira uma chave de licença válida para habilitar atualizações automáticas.\";}s:27:\"astra-addon/astra-addon.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:11:\"astra-addon\";s:4:\"slug\";s:11:\"astra-addon\";s:6:\"plugin\";s:27:\"astra-addon/astra-addon.php\";s:14:\"upgrade_notice\";s:59:\" Please activate your license to receive automatic updates.\";s:11:\"new_version\";s:5:\"1.8.8\";s:3:\"url\";s:126:\"https://wpastra.com/pricing/?utm_source=graupi-license-form&utm_medium=graupi-license-invalidation&utm_campaign=purchase-astra\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:1:{s:7:\"default\";b:0;}}s:39:\"bb-ultimate-addon/bb-ultimate-addon.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:4:\"uabb\";s:4:\"slug\";s:17:\"bb-ultimate-addon\";s:6:\"plugin\";s:39:\"bb-ultimate-addon/bb-ultimate-addon.php\";s:14:\"upgrade_notice\";s:59:\" Please activate your license to receive automatic updates.\";s:11:\"new_version\";s:6:\"1.20.0\";s:3:\"url\";s:120:\"https://www.ultimatebeaver.com/pricing/?utm_source=uabb-pro-dashboard&utm_medium=license-screen&utm_campaign=get-license\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"5.2.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/10/uabb-logo.svg\";s:2:\"2x\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/10/uabb-logo.svg\";s:7:\"default\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/10/uabb-logo.svg\";}}s:28:\"bbpowerpack/bb-powerpack.php\";O:8:\"stdClass\":14:{s:11:\"new_version\";s:5:\"2.7.3\";s:14:\"stable_version\";s:5:\"2.7.3\";s:4:\"name\";s:28:\"PowerPack for Beaver Builder\";s:4:\"slug\";s:12:\"bb-powerpack\";s:3:\"url\";s:59:\"https://wpbeaveraddons.com/downloads/powerpack/?changelog=1\";s:12:\"last_updated\";s:19:\"2019-08-12 00:33:30\";s:8:\"homepage\";s:47:\"https://wpbeaveraddons.com/downloads/powerpack/\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";s:8:\"sections\";O:8:\"stdClass\":2:{s:11:\"description\";s:79:\"<p>PowerPack is a set of custom modules and templates for Beaver Builder.</p>\n\";s:9:\"changelog\";s:145:\"<p>Please check the <a href=\"https://wpbeaveraddons.com/change-logs/\" target=\"_blank\" rel=\"noopener\">changelog page</a> for all the details.</p>\n\";}s:7:\"banners\";O:8:\"stdClass\":2:{s:4:\"high\";s:0:\"\";s:3:\"low\";s:0:\"\";}s:5:\"icons\";a:0:{}s:11:\"description\";a:1:{i:0;s:79:\"<p>PowerPack is a set of custom modules and templates for Beaver Builder.</p>\n\";}s:9:\"changelog\";a:1:{i:0;s:145:\"<p>Please check the <a href=\"https://wpbeaveraddons.com/change-logs/\" target=\"_blank\" rel=\"noopener\">changelog page</a> for all the details.</p>\n\";}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:37:\"bb-header-footer/bb-header-footer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/bb-header-footer\";s:4:\"slug\";s:16:\"bb-header-footer\";s:6:\"plugin\";s:37:\"bb-header-footer/bb-header-footer.php\";s:11:\"new_version\";s:5:\"1.1.7\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/bb-header-footer/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/bb-header-footer.1.1.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/bb-header-footer/assets/icon-256x256.png?rev=1569336\";s:2:\"1x\";s:69:\"https://ps.w.org/bb-header-footer/assets/icon-128x128.png?rev=1569218\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/bb-header-footer/assets/banner-1544x500.png?rev=1569346\";s:2:\"1x\";s:71:\"https://ps.w.org/bb-header-footer/assets/banner-772x250.png?rev=1569345\";}s:11:\"banners_rtl\";a:0:{}}}s:7:\"checked\";a:2:{s:9:\"bb-plugin\";s:5:\"2.2.3\";s:28:\"bbpowerpack/bb-powerpack.php\";s:7:\"2.7.0.1\";}}", "no");
INSERT INTO `wptj_options` VALUES("615", "_site_transient_timeout_browser_43fbb95c9bbbf2dcd00331855caa9051", "1566421992", "no");
INSERT INTO `wptj_options` VALUES("616", "_site_transient_browser_43fbb95c9bbbf2dcd00331855caa9051", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"68.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wptj_options` VALUES("617", "_site_transient_timeout_php_check_8706d9e16ec2aa6542c624d1e3c9facd", "1566421993", "no");
INSERT INTO `wptj_options` VALUES("618", "_site_transient_php_check_8706d9e16ec2aa6542c624d1e3c9facd", "a:5:{s:19:\"recommended_version\";s:3:\"7.3\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wptj_options` VALUES("601", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"klecinho.ar@gmail.com\";s:7:\"version\";s:5:\"5.2.2\";s:9:\"timestamp\";i:1561584985;}", "no");
INSERT INTO `wptj_options` VALUES("533", "duplicator_package_active", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-14 21:15:37\";s:7:\"Version\";s:6:\"1.3.14\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.6.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:12:\"20190612_dmk\";s:4:\"Hash\";s:35:\"b23c67b27d23a0e56571_20190814211537\";s:8:\"NameHash\";s:48:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"/home/klestersrfcom/public_html/dmk/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"https://siterapidofacil.com/dmk/wp-snapshots/\";s:8:\"ScanFile\";s:58:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/home/klestersrfcom/public_html/dmk\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-14 21:15:37\";s:7:\"Version\";s:6:\"1.3.14\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.6.44\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:12:\"20190612_dmk\";s:4:\"Hash\";s:35:\"b23c67b27d23a0e56571_20190814211537\";s:8:\"NameHash\";s:48:\"20190612_dmk_b23c67b27d23a0e56571_20190814211537\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"/home/klestersrfcom/public_html/dmk/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"https://siterapidofacil.com/dmk/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:44:\"/home/klestersrfcom/public_html/dmk/wp-admin\";i:1;s:54:\"/home/klestersrfcom/public_html/dmk/wp-content/uploads\";i:2;s:56:\"/home/klestersrfcom/public_html/dmk/wp-content/languages\";i:3;s:53:\"/home/klestersrfcom/public_html/dmk/wp-content/themes\";i:4;s:47:\"/home/klestersrfcom/public_html/dmk/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:35:\"/home/klestersrfcom/public_html/dmk\";i:1;s:46:\"/home/klestersrfcom/public_html/dmk/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:128;}", "yes");
INSERT INTO `wptj_options` VALUES("528", "duplicator_settings", "a:13:{s:7:\"version\";s:6:\"1.3.14\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:17:\"active_package_id\";i:2;}", "yes");
INSERT INTO `wptj_options` VALUES("529", "duplicator_version_plugin", "1.3.14", "yes");
INSERT INTO `wptj_options` VALUES("619", "_transient_timeout_astra-theme-rating", "1568409249", "no");
INSERT INTO `wptj_options` VALUES("620", "_transient_astra-theme-rating", "1", "no");
INSERT INTO `wptj_options` VALUES("621", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wptj_options` VALUES("554", "litespeed-cache_uri_priv", "", "yes");
INSERT INTO `wptj_options` VALUES("555", "litespeed-cache-drop_qs", "", "yes");
INSERT INTO `wptj_options` VALUES("556", "litespeed-forced_cache_uri", "", "yes");
INSERT INTO `wptj_options` VALUES("557", "litespeed-excludes_uri", "", "yes");
INSERT INTO `wptj_options` VALUES("558", "litespeed-cache-exclude-cache-roles", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("559", "litespeed-optm-css", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("560", "litespeed-optm_excludes", "", "yes");
INSERT INTO `wptj_options` VALUES("561", "litespeed-optm-js-defer-excludes", "", "yes");
INSERT INTO `wptj_options` VALUES("562", "litespeed-cache-exclude-optimization-roles", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("563", "litespeed-cache-dns_prefetch", "", "yes");
INSERT INTO `wptj_options` VALUES("564", "litespeed-optm-ccss-separate_posttype", "", "yes");
INSERT INTO `wptj_options` VALUES("565", "litespeed-optm-css-separate_uri", "", "yes");
INSERT INTO `wptj_options` VALUES("566", "litespeed-media-lazy-img-excludes", "", "yes");
INSERT INTO `wptj_options` VALUES("567", "litespeed-media-lazy-img-cls-excludes", "", "yes");
INSERT INTO `wptj_options` VALUES("568", "litespeed-media-webp_attribute", "img.src\ndiv.data-thumb\nimg.data-src\ndiv.data-large_image\nimg.retina_logo_url", "yes");
INSERT INTO `wptj_options` VALUES("569", "litespeed-cdn-ori_dir", "wp-content\nwp-includes\n/min/", "yes");
INSERT INTO `wptj_options` VALUES("570", "litespeed-cache-cdn_mapping", "a:1:{i:0;a:5:{s:3:\"url\";b:0;s:7:\"inc_img\";s:1:\"1\";s:7:\"inc_css\";s:1:\"1\";s:6:\"inc_js\";s:1:\"1\";s:8:\"filetype\";s:86:\".aac\n.css\n.eot\n.gif\n.jpeg\n.js\n.jpg\n.less\n.mp3\n.mp4\n.ogg\n.otf\n.pdf\n.png\n.svg\n.ttf\n.woff\";}}", "yes");
INSERT INTO `wptj_options` VALUES("571", "litespeed-adv-purge_all_hooks", "switch_theme\nwp_create_nav_menu\nwp_update_nav_menu\nwp_delete_nav_menu\ncreate_term\nedit_terms\ndelete_term\nadd_link\nedit_link\ndelete_link", "yes");
INSERT INTO `wptj_options` VALUES("572", "litespeed-log_ignore_filters", "gettext\ngettext_with_context\nget_the_terms\nget_term", "yes");
INSERT INTO `wptj_options` VALUES("573", "litespeed-log_ignore_part_filters", "i18n\nlocale\nsettings\noption", "yes");
INSERT INTO `wptj_options` VALUES("574", "litespeed-crawler-as-uids", "", "yes");
INSERT INTO `wptj_options` VALUES("575", "litespeed-crawler-cookies", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("576", "litespeed-object_global_groups", "users\nuserlogins\nusermeta\nuser_meta\nsite-transient\nsite-options\nsite-lookup\nblog-lookup\nblog-details\nrss\nglobal-posts\nblog-id-cache", "yes");
INSERT INTO `wptj_options` VALUES("577", "litespeed-object_non_persistent_groups", "comment\ncounts\nplugins", "yes");
INSERT INTO `wptj_options` VALUES("578", "litespeed-cache-vary-group", "", "yes");
INSERT INTO `wptj_options` VALUES("590", "litespeed-timestamp-purge-css", "1560667667", "yes");
INSERT INTO `wptj_options` VALUES("154", "bsf_force_check_extensions", "", "no");
INSERT INTO `wptj_options` VALUES("178", "astra_sites_recent_import_log_file", "/home/klestersrfcom/public_html/dmk/wp-content/uploads/astra-sites/import-22-May-2019-10-57-08.txt", "yes");
INSERT INTO `wptj_options` VALUES("157", "bb_powerpack_templates", "a:1:{i:0;s:8:\"disabled\";}", "yes");
INSERT INTO `wptj_options` VALUES("158", "bb_powerpack_page_templates", "a:1:{i:0;s:8:\"disabled\";}", "yes");
INSERT INTO `wptj_options` VALUES("159", "bb_powerpack_templates_reset", "1", "yes");
INSERT INTO `wptj_options` VALUES("160", "_uabb_1_7_2_ver", "yes", "yes");
INSERT INTO `wptj_options` VALUES("161", "_journey_details", "a:3:{i:0;a:2:{s:16:\"previous_version\";s:1:\"0\";s:15:\"current_version\";s:6:\"1.16.5\";}i:1;a:2:{s:16:\"previous_version\";s:6:\"1.16.5\";s:15:\"current_version\";s:6:\"1.17.0\";}i:2;a:2:{s:16:\"previous_version\";s:6:\"1.17.0\";s:15:\"current_version\";s:6:\"1.17.1\";}}", "yes");
INSERT INTO `wptj_options` VALUES("162", "_uabb_saved_version", "1.17.1", "yes");
INSERT INTO `wptj_options` VALUES("163", "_fl_builder_enabled_icons", "a:6:{i:0;s:22:\"font-awesome-5-regular\";i:1;s:20:\"font-awesome-5-solid\";i:2;s:21:\"font-awesome-5-brands\";i:3;s:16:\"foundation-icons\";i:4;s:9:\"dashicons\";i:5;s:14:\"ultimate-icons\";}", "yes");
INSERT INTO `wptj_options` VALUES("164", "_uabb_enabled_icons", "1", "yes");
INSERT INTO `wptj_options` VALUES("165", "_fl_builder_version", "2.2.3", "no");
INSERT INTO `wptj_options` VALUES("166", "bsf_local_transient", "1565817179", "yes");
INSERT INTO `wptj_options` VALUES("196", "_fl_builder_enabled_modules", "a:137:{i:0;s:3:\"all\";i:1;s:6:\"button\";i:2;s:7:\"heading\";i:3;s:9:\"rich-text\";i:4;s:4:\"html\";i:5;s:5:\"photo\";i:6;s:9:\"separator\";i:7;s:5:\"video\";i:8;s:5:\"audio\";i:9;s:9:\"slideshow\";i:10;s:12:\"testimonials\";i:11;s:7:\"gallery\";i:12;s:10:\"icon-group\";i:13;s:3:\"map\";i:14;s:14:\"content-slider\";i:15;s:4:\"icon\";i:16;s:14:\"social-buttons\";i:17;s:7:\"callout\";i:18;s:3:\"cta\";i:19;s:12:\"contact-form\";i:20;s:14:\"subscribe-form\";i:21;s:4:\"menu\";i:22;s:4:\"tabs\";i:23;s:7:\"sidebar\";i:24;s:9:\"accordion\";i:25;s:13:\"pricing-table\";i:26;s:7:\"numbers\";i:27;s:9:\"countdown\";i:28;s:13:\"post-carousel\";i:29;s:9:\"post-grid\";i:30;s:11:\"post-slider\";i:31;s:12:\"pp-3d-slider\";i:32;s:16:\"pp-advanced-menu\";i:33;s:21:\"pp-animated-headlines\";i:34;s:19:\"pp-column-separator\";i:35;s:12:\"pp-countdown\";i:36;s:17:\"pp-line-separator\";i:37;s:9:\"pp-dotnav\";i:38;s:18:\"pp-facebook-button\";i:39;s:20:\"pp-facebook-comments\";i:40;s:17:\"pp-facebook-embed\";i:41;s:16:\"pp-facebook-page\";i:42;s:16:\"pp-fancy-heading\";i:43;s:10:\"pp-flipbox\";i:44;s:16:\"pp-highlight-box\";i:45;s:14:\"pp-hover-cards\";i:46;s:16:\"pp-hover-cards-2\";i:47;s:17:\"pp-instagram-feed\";i:48;s:13:\"pp-logos-grid\";i:49;s:16:\"pp-post-timeline\";i:50;s:9:\"pp-spacer\";i:51;s:11:\"pp-timeline\";i:52;s:18:\"pp-twitter-buttons\";i:53;s:15:\"pp-twitter-grid\";i:54;s:19:\"pp-twitter-timeline\";i:55;s:16:\"pp-twitter-tweet\";i:56;s:21:\"pp-advanced-accordion\";i:57;s:16:\"pp-advanced-tabs\";i:58;s:17:\"pp-business-hours\";i:59;s:15:\"pp-content-grid\";i:60;s:16:\"pp-content-tiles\";i:61;s:14:\"pp-dual-button\";i:62;s:21:\"pp-filterable-gallery\";i:63;s:11:\"pp-iconlist\";i:64;s:8:\"pp-image\";i:65;s:17:\"pp-image-carousel\";i:66;s:15:\"pp-image-panels\";i:67;s:10:\"pp-infobox\";i:68;s:11:\"pp-infolist\";i:69;s:10:\"pp-gallery\";i:70;s:16:\"pp-pricing-table\";i:71;s:12:\"pp-pullquote\";i:72;s:18:\"pp-restaurant-menu\";i:73;s:15:\"pp-smart-button\";i:74;s:10:\"pp-heading\";i:75;s:15:\"pp-social-icons\";i:76;s:8:\"pp-table\";i:77;s:7:\"pp-team\";i:78;s:15:\"pp-testimonials\";i:79;s:16:\"pp-notifications\";i:80;s:19:\"pp-announcement-bar\";i:81;s:12:\"pp-modal-box\";i:82;s:14:\"pp-info-banner\";i:83;s:15:\"pp-contact-form\";i:84;s:17:\"pp-subscribe-form\";i:85;s:18:\"advanced-accordion\";i:86;s:13:\"advanced-icon\";i:87;s:10:\"blog-posts\";i:88;s:13:\"advanced-tabs\";i:89;s:19:\"uabb-business-hours\";i:90;s:19:\"uabb-content-toggle\";i:91;s:10:\"google-map\";i:92;s:12:\"uabb-heading\";i:93;s:10:\"image-icon\";i:94;s:11:\"info-banner\";i:95;s:8:\"info-box\";i:96;s:9:\"info-list\";i:97;s:10:\"info-table\";i:98;s:20:\"interactive-banner-1\";i:99;s:9:\"list-icon\";i:100;s:10:\"uabb-photo\";i:101;s:13:\"photo-gallery\";i:102;s:11:\"pricing-box\";i:103;s:15:\"uabb-price-list\";i:104;s:14:\"uabb-separator\";i:105;s:10:\"uabb-table\";i:106;s:4:\"team\";i:107;s:16:\"adv-testimonials\";i:108;s:10:\"uabb-video\";i:109;s:18:\"uabb-video-gallery\";i:110;s:18:\"uabb-advanced-menu\";i:111;s:18:\"advanced-separator\";i:112;s:12:\"uabb-numbers\";i:113;s:13:\"creative-link\";i:114;s:11:\"dual-button\";i:115;s:18:\"dual-color-heading\";i:116;s:10:\"fancy-text\";i:117;s:8:\"flip-box\";i:118;s:15:\"image-separator\";i:119;s:11:\"info-circle\";i:120;s:20:\"interactive-banner-2\";i:121;s:12:\"progress-bar\";i:122;s:9:\"slide-box\";i:123;s:6:\"ihover\";i:124;s:22:\"uabb-beforeafterslider\";i:125;s:14:\"uabb-countdown\";i:126;s:12:\"uabb-hotspot\";i:127;s:19:\"uabb-image-carousel\";i:128;s:17:\"uabb-social-share\";i:129;s:10:\"spacer-gap\";i:130;s:11:\"uabb-button\";i:131;s:19:\"uabb-call-to-action\";i:132;s:17:\"uabb-contact-form\";i:133;s:11:\"modal-popup\";i:134;s:6:\"ribbon\";i:135;s:24:\"mailchimp-subscribe-form\";i:136;s:6:\"widget\";}", "yes");
INSERT INTO `wptj_options` VALUES("169", "bsf-updater-version", "1.22.63\n", "yes");
INSERT INTO `wptj_options` VALUES("170", "brainstrom_products", "a:2:{s:7:\"plugins\";a:2:{s:11:\"astra-addon\";a:32:{s:2:\"id\";s:11:\"astra-addon\";s:4:\"name\";s:9:\"Astra Pro\";s:4:\"slug\";s:11:\"astra-addon\";s:10:\"short_name\";s:9:\"Astra Pro\";s:11:\"description\";s:155:\"This plugin is an add-on for the Astra WordPress Theme. It offers premium features & functionalities that enhance your theming experience at next level..\r\n\";s:7:\"version\";s:5:\"1.8.2\";s:12:\"download_url\";s:22:\"astra-addon-plugin.zip\";s:12:\"version_beta\";s:10:\"2.0.0-rc.1\";s:17:\"download_url_beta\";s:27:\"astra-addon-plugin-beta.zip\";s:6:\"tested\";s:3:\"5.2\";s:14:\"privacy_policy\";s:120:\"https://wpastra.com/privacy-policy/?utm_source=graupi-license-form&utm_medium=privacy-policy&utm_campaign=purchase-astra\";s:16:\"terms_conditions\";s:132:\"https://wpastra.com/terms-and-conditions/?utm_source=graupi-license-form&utm_medium=terms-and-conditions&utm_campaign=purchase-astra\";s:12:\"purchase_url\";s:126:\"https://wpastra.com/pricing/?utm_source=graupi-license-form&utm_medium=graupi-license-invalidation&utm_campaign=purchase-astra\";s:13:\"changelog_url\";s:142:\"https://wpastra.com/changelog/astra-pro-addon/?utm_source=graupi-license-form&utm_medium=astra-pro-addon-changelog&utm_campaign=purchase-astra\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:4:\"true\";s:13:\"support_forum\";s:130:\"https://wpastra.com/support/submit-a-ticket/?utm_source=graupi-license-form&utm_medium=submit-a-ticket&utm_campaign=purchase-astra\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2018/12/astra-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:27:\"astra-addon/astra-addon.php\";s:6:\"remote\";s:5:\"1.8.8\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:14:\"not-registered\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:9:\"Astra Pro\";}s:4:\"uabb\";a:32:{s:2:\"id\";s:4:\"uabb\";s:4:\"name\";s:34:\"Ultimate Addons for Beaver Builder\";s:4:\"slug\";s:17:\"bb-ultimate-addon\";s:10:\"short_name\";s:22:\"Ultimate Addons for BB\";s:11:\"description\";s:132:\"UABB is a premium extension for Beaver Builder that adds 55+ modules, 200+ templates and works on top of any Beaver Builder Package.\";s:7:\"version\";s:6:\"1.17.1\";s:12:\"download_url\";s:21:\"bb-ultimate-addon.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:5:\"5.2.2\";s:14:\"privacy_policy\";s:127:\"https://www.ultimatebeaver.com/privacy-policy/?utm_source=uabb-pro-dashboard&utm_medium=privacy-policy&utm_campaign=get-license\";s:16:\"terms_conditions\";s:139:\"https://www.ultimatebeaver.com/terms-and-conditions/?utm_source=uabb-pro-dashboard&utm_medium=terms-and-conditions&utm_campaign=get-license\";s:12:\"purchase_url\";s:120:\"https://www.ultimatebeaver.com/pricing/?utm_source=uabb-pro-dashboard&utm_medium=license-screen&utm_campaign=get-license\";s:13:\"changelog_url\";s:117:\"https://www.ultimatebeaver.com/changelog/?utm_source=uabb-pro-dashboard&utm_medium=changelog&utm_campaign=get-license\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:134:\"https://www.ultimatebeaver.com/support/submit-a-ticket/?utm_source=uabb-pro-dashboard&utm_medium=support-form&utm_campaign=get-license\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/10/uabb-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:39:\"bb-ultimate-addon/bb-ultimate-addon.php\";s:6:\"remote\";s:6:\"1.20.0\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:14:\"not-registered\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:34:\"Ultimate Addons for Beaver Builder\";}}s:6:\"themes\";a:1:{s:5:\"astra\";a:32:{s:2:\"id\";s:5:\"astra\";s:4:\"name\";s:5:\"Astra\";s:4:\"slug\";s:5:\"astra\";s:10:\"short_name\";s:5:\"Astra\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:5:\"1.8.4\";s:12:\"download_url\";s:15:\"astra-1.4.9.zip\";s:12:\"version_beta\";s:10:\"2.0.0-rc.1\";s:17:\"download_url_beta\";s:14:\"astra-beta.zip\";s:6:\"tested\";s:3:\"5.2\";s:14:\"privacy_policy\";s:0:\"\";s:16:\"terms_conditions\";s:0:\"\";s:12:\"purchase_url\";s:0:\"\";s:13:\"changelog_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:4:\"true\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:0:\"\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2018/12/astra-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:4:\"true\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:5:\"astra\";s:6:\"remote\";s:5:\"0.0.1\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:14:\"not-registered\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:5:\"Astra\";}}}", "yes");
INSERT INTO `wptj_options` VALUES("172", "bsf_local_transient_bundled", "1565817189", "yes");
INSERT INTO `wptj_options` VALUES("179", "_uabb_cloud_templats", "a:2:{s:14:\"page-templates\";a:119:{s:21:\"site-1-template-17674\";a:7:{s:2:\"id\";s:21:\"site-1-template-17674\";s:4:\"name\";s:6:\"Lawyer\";s:5:\"image\";s:110:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/landing-page4-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17674.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:53:\"https://templates.ultimatebeaver.com/template/lawyer/\";}s:21:\"site-1-template-17668\";a:7:{s:2:\"id\";s:21:\"site-1-template-17668\";s:4:\"name\";s:9:\"Dietitian\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/landing-page22-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17668.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:56:\"https://templates.ultimatebeaver.com/template/dietitian/\";}s:21:\"site-1-template-17649\";a:7:{s:2:\"id\";s:21:\"site-1-template-17649\";s:4:\"name\";s:19:\"Photography Website\";s:5:\"image\";s:129:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/Photography-Website-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17649.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/template/photography-website/\";}s:21:\"site-1-template-17384\";a:7:{s:2:\"id\";s:21:\"site-1-template-17384\";s:4:\"name\";s:11:\"Coffee Shop\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/landing-page15-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17384.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/coffee-shop/\";}s:21:\"site-1-template-17379\";a:7:{s:2:\"id\";s:21:\"site-1-template-17379\";s:4:\"name\";s:18:\"Mobile Application\";s:5:\"image\";s:128:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/mobile-application-landing-page-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17379.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:65:\"https://templates.ultimatebeaver.com/template/mobile-application/\";}s:21:\"site-1-template-17354\";a:7:{s:2:\"id\";s:21:\"site-1-template-17354\";s:4:\"name\";s:20:\"Online Jewelry Store\";s:5:\"image\";s:123:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/07/jwelery-store-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17354.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:67:\"https://templates.ultimatebeaver.com/template/online-jewelry-store/\";}s:21:\"site-1-template-17069\";a:7:{s:2:\"id\";s:21:\"site-1-template-17069\";s:4:\"name\";s:4:\"Yoga\";s:5:\"image\";s:114:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/yoga-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17069.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:53:\"https://templates.ultimatebeaver.com/template/yoga-2/\";}s:21:\"site-1-template-17068\";a:7:{s:2:\"id\";s:21:\"site-1-template-17068\";s:4:\"name\";s:16:\"SEO or Marketing\";s:5:\"image\";s:98:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/1-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17068.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/template/seo-or-marketing/\";}s:21:\"site-1-template-17066\";a:7:{s:2:\"id\";s:21:\"site-1-template-17066\";s:4:\"name\";s:7:\"Dentist\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/landing-page21-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-17066.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/dentist/\";}s:21:\"site-1-template-16591\";a:7:{s:2:\"id\";s:21:\"site-1-template-16591\";s:4:\"name\";s:15:\"Personal Resume\";s:5:\"image\";s:125:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/personal-resume-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16591.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/template/personal-resume/\";}s:21:\"site-1-template-16586\";a:7:{s:2:\"id\";s:21:\"site-1-template-16586\";s:4:\"name\";s:19:\"Automotive Services\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/landing-page05-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16586.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/template/automotive-services/\";}s:21:\"site-1-template-16585\";a:7:{s:2:\"id\";s:21:\"site-1-template-16585\";s:4:\"name\";s:16:\"Insurance Agency\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/06/landing-page36-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16585.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/template/insurance-agency/\";}s:21:\"site-1-template-16279\";a:7:{s:2:\"id\";s:21:\"site-1-template-16279\";s:4:\"name\";s:21:\"Internal Product Page\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page37-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16279.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/template/internal-product/\";}s:21:\"site-1-template-16272\";a:7:{s:2:\"id\";s:21:\"site-1-template-16272\";s:4:\"name\";s:17:\"Confirmation Page\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page01-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16272.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:59:\"https://templates.ultimatebeaver.com/template/confirmation/\";}s:21:\"site-1-template-16255\";a:7:{s:2:\"id\";s:21:\"site-1-template-16255\";s:4:\"name\";s:10:\"Web Agency\";s:5:\"image\";s:120:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/web-agency-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16255.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/web-agency/\";}s:21:\"site-1-template-16246\";a:7:{s:2:\"id\";s:21:\"site-1-template-16246\";s:4:\"name\";s:24:\"Professional Real Estate\";s:5:\"image\";s:133:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/professional-realestate-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16246.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/real-estate-3/\";}s:21:\"site-1-template-16213\";a:7:{s:2:\"id\";s:21:\"site-1-template-16213\";s:4:\"name\";s:7:\"Charity\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page14-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-16213.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/charity/\";}s:21:\"site-1-template-15958\";a:7:{s:2:\"id\";s:21:\"site-1-template-15958\";s:4:\"name\";s:13:\"Travel Offers\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/travel-offer-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15958.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/travels/\";}s:21:\"site-1-template-15940\";a:7:{s:2:\"id\";s:21:\"site-1-template-15940\";s:4:\"name\";s:19:\"Agency Service Page\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page02-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15940.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/agency-service/\";}s:21:\"site-1-template-15645\";a:7:{s:2:\"id\";s:21:\"site-1-template-15645\";s:4:\"name\";s:12:\"Multipurpose\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/multipurpose-landing-page-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15645.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:59:\"https://templates.ultimatebeaver.com/template/multipurpose/\";}s:21:\"site-1-template-15641\";a:7:{s:2:\"id\";s:21:\"site-1-template-15641\";s:4:\"name\";s:13:\"Online Portal\";s:5:\"image\";s:123:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/online-portal-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15641.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/online-portal/\";}s:21:\"site-1-template-15638\";a:7:{s:2:\"id\";s:21:\"site-1-template-15638\";s:4:\"name\";s:15:\"Product Release\";s:5:\"image\";s:125:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/product-release-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15638.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/template/product-release/\";}s:21:\"site-1-template-15635\";a:7:{s:2:\"id\";s:21:\"site-1-template-15635\";s:4:\"name\";s:14:\"Thank You Page\";s:5:\"image\";s:118:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/thankyou-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15635.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:56:\"https://templates.ultimatebeaver.com/template/thank-you/\";}s:21:\"site-1-template-15632\";a:7:{s:2:\"id\";s:21:\"site-1-template-15632\";s:4:\"name\";s:20:\"Fitness and Work-out\";s:5:\"image\";s:113:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page31-free-img-1-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15632.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:55:\"https://templates.ultimatebeaver.com/template/work-out/\";}s:21:\"site-1-template-15624\";a:7:{s:2:\"id\";s:21:\"site-1-template-15624\";s:4:\"name\";s:7:\"Fitness\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page30-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15624.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/fitness/\";}s:21:\"site-1-template-15621\";a:7:{s:2:\"id\";s:21:\"site-1-template-15621\";s:4:\"name\";s:11:\"Lead Magnet\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page42-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15621.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/lead-magnet/\";}s:21:\"site-1-template-15617\";a:7:{s:2:\"id\";s:21:\"site-1-template-15617\";s:4:\"name\";s:24:\"Professional Consultants\";s:5:\"image\";s:133:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/professional-consultant-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15617.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/consultants/\";}s:21:\"site-1-template-15613\";a:7:{s:2:\"id\";s:21:\"site-1-template-15613\";s:4:\"name\";s:16:\"Attractive Offer\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-page04-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15613.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:53:\"https://templates.ultimatebeaver.com/template/offers/\";}s:21:\"site-1-template-15610\";a:7:{s:2:\"id\";s:21:\"site-1-template-15610\";s:4:\"name\";s:14:\"Local Business\";s:5:\"image\";s:119:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/02/landing-local-business-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15610.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/local-business/\";}s:21:\"site-1-template-15363\";a:7:{s:2:\"id\";s:21:\"site-1-template-15363\";s:4:\"name\";s:14:\"After Download\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page19-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15363.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/after-download/\";}s:21:\"site-1-template-15276\";a:7:{s:2:\"id\";s:21:\"site-1-template-15276\";s:4:\"name\";s:11:\"Real Estate\";s:5:\"image\";s:120:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/realestate-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15276.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/real-estate/\";}s:21:\"site-1-template-15059\";a:7:{s:2:\"id\";s:21:\"site-1-template-15059\";s:4:\"name\";s:7:\"Seminar\";s:5:\"image\";s:117:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/seminar-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15059.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/seminar/\";}s:21:\"site-1-template-15032\";a:7:{s:2:\"id\";s:21:\"site-1-template-15032\";s:4:\"name\";s:22:\"Travel and Hospitality\";s:5:\"image\";s:128:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/travel-hospitality-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15032.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/hospitality/\";}s:21:\"site-1-template-15018\";a:7:{s:2:\"id\";s:21:\"site-1-template-15018\";s:4:\"name\";s:10:\"Conference\";s:5:\"image\";s:102:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page18-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15018.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/conference/\";}s:21:\"site-1-template-15011\";a:7:{s:2:\"id\";s:21:\"site-1-template-15011\";s:4:\"name\";s:10:\"E-learning\";s:5:\"image\";s:107:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/e-learning-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-15011.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/e-learning/\";}s:21:\"site-1-template-14994\";a:7:{s:2:\"id\";s:21:\"site-1-template-14994\";s:4:\"name\";s:12:\"Registration\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/registration-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14994.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:59:\"https://templates.ultimatebeaver.com/template/registration/\";}s:21:\"site-1-template-14991\";a:7:{s:2:\"id\";s:21:\"site-1-template-14991\";s:4:\"name\";s:20:\"Introduce a Software\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page38-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14991.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:55:\"https://templates.ultimatebeaver.com/template/software/\";}s:21:\"site-1-template-14985\";a:7:{s:2:\"id\";s:21:\"site-1-template-14985\";s:4:\"name\";s:18:\"Event Registration\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page27-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14985.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:65:\"https://templates.ultimatebeaver.com/template/event-registration/\";}s:21:\"site-1-template-14984\";a:7:{s:2:\"id\";s:21:\"site-1-template-14984\";s:4:\"name\";s:11:\"Offer Ebook\";s:5:\"image\";s:121:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/offer-ebook-landing-page-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14984.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/offer-ebook/\";}s:21:\"site-1-template-14979\";a:7:{s:2:\"id\";s:21:\"site-1-template-14979\";s:4:\"name\";s:22:\"Professional Portfolio\";s:5:\"image\";s:132:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/professional-portfolio-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14979.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:56:\"https://templates.ultimatebeaver.com/template/portfolio/\";}s:21:\"site-1-template-14978\";a:7:{s:2:\"id\";s:21:\"site-1-template-14978\";s:4:\"name\";s:5:\"Event\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page26-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14978.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:52:\"https://templates.ultimatebeaver.com/template/event/\";}s:21:\"site-1-template-14970\";a:7:{s:2:\"id\";s:21:\"site-1-template-14970\";s:4:\"name\";s:13:\"Online Course\";s:5:\"image\";s:123:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/online-course-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14970.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/online-course/\";}s:21:\"site-1-template-14969\";a:7:{s:2:\"id\";s:21:\"site-1-template-14969\";s:4:\"name\";s:15:\"Seasonal Offers\";s:5:\"image\";s:125:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/sessional-offer-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14969.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/template/seasonal-offers/\";}s:21:\"site-1-template-14901\";a:7:{s:2:\"id\";s:21:\"site-1-template-14901\";s:4:\"name\";s:12:\"Product page\";s:5:\"image\";s:117:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/product-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14901.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:59:\"https://templates.ultimatebeaver.com/template/product-page/\";}s:21:\"site-1-template-14895\";a:7:{s:2:\"id\";s:21:\"site-1-template-14895\";s:4:\"name\";s:13:\"Health Clinic\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page35-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14895.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/health-clinic/\";}s:21:\"site-1-template-14884\";a:7:{s:2:\"id\";s:21:\"site-1-template-14884\";s:4:\"name\";s:16:\"Beauty Treatment\";s:5:\"image\";s:114:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/beautytreatment07-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14884.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/template/beauty-treatment/\";}s:21:\"site-1-template-14876\";a:7:{s:2:\"id\";s:21:\"site-1-template-14876\";s:4:\"name\";s:19:\"Ebook Download page\";s:5:\"image\";s:123:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/ebook-download-landingpage-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14876.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/ebook-download/\";}s:21:\"site-1-template-14862\";a:7:{s:2:\"id\";s:21:\"site-1-template-14862\";s:4:\"name\";s:15:\"Wedding Website\";s:5:\"image\";s:117:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/wedding-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14862.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/wedding/\";}s:21:\"site-1-template-14809\";a:7:{s:2:\"id\";s:21:\"site-1-template-14809\";s:4:\"name\";s:7:\"Tourism\";s:5:\"image\";s:117:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/tourism-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14809.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/tourism/\";}s:21:\"site-1-template-14801\";a:7:{s:2:\"id\";s:21:\"site-1-template-14801\";s:4:\"name\";s:15:\"Creative Agency\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page20-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14801.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/template/creative-agency/\";}s:21:\"site-1-template-14757\";a:7:{s:2:\"id\";s:21:\"site-1-template-14757\";s:4:\"name\";s:10:\"Book Store\";s:5:\"image\";s:116:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-bookstore10-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14757.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/book-store/\";}s:21:\"site-1-template-14745\";a:7:{s:2:\"id\";s:21:\"site-1-template-14745\";s:4:\"name\";s:18:\"Financial Services\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page29-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14745.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:65:\"https://templates.ultimatebeaver.com/template/financial-services/\";}s:21:\"site-1-template-14734\";a:7:{s:2:\"id\";s:21:\"site-1-template-14734\";s:4:\"name\";s:15:\"App or Software\";s:5:\"image\";s:110:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page03free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14734.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:50:\"https://templates.ultimatebeaver.com/template/app/\";}s:21:\"site-1-template-14728\";a:7:{s:2:\"id\";s:21:\"site-1-template-14728\";s:4:\"name\";s:17:\"Multipurpose Page\";s:5:\"image\";s:127:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/multipurpose-page-landing-page-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14728.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/multipurpose-2/\";}s:21:\"site-1-template-14718\";a:7:{s:2:\"id\";s:21:\"site-1-template-14718\";s:4:\"name\";s:3:\"Spa\";s:5:\"image\";s:118:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/spa-page-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14718.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:50:\"https://templates.ultimatebeaver.com/template/spa/\";}s:21:\"site-1-template-14715\";a:7:{s:2:\"id\";s:21:\"site-1-template-14715\";s:4:\"name\";s:23:\"Product or Service page\";s:5:\"image\";s:126:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/prosduct-service-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14715.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/product/\";}s:21:\"site-1-template-14711\";a:7:{s:2:\"id\";s:21:\"site-1-template-14711\";s:4:\"name\";s:11:\"Free Report\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page34-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14711.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/free-report/\";}s:21:\"site-1-template-14675\";a:7:{s:2:\"id\";s:21:\"site-1-template-14675\";s:4:\"name\";s:18:\"Product Free Trial\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/product-free-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14675.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/product-trial/\";}s:21:\"site-1-template-14671\";a:7:{s:2:\"id\";s:21:\"site-1-template-14671\";s:4:\"name\";s:9:\"Marketing\";s:5:\"image\";s:119:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/marketing-landing-page-free-img-400x398.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14671.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:56:\"https://templates.ultimatebeaver.com/template/marketing/\";}s:21:\"site-1-template-14631\";a:7:{s:2:\"id\";s:21:\"site-1-template-14631\";s:4:\"name\";s:11:\"Food Offers\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page32-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14631.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/food-offers/\";}s:21:\"site-1-template-14589\";a:7:{s:2:\"id\";s:21:\"site-1-template-14589\";s:4:\"name\";s:15:\"Pre-launch Page\";s:5:\"image\";s:120:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/pre-launch-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14589.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/pre-launch/\";}s:21:\"site-1-template-14509\";a:7:{s:2:\"id\";s:21:\"site-1-template-14509\";s:4:\"name\";s:15:\"Online Training\";s:5:\"image\";s:125:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/online-training-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14509.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/template/online-training/\";}s:21:\"site-1-template-14506\";a:7:{s:2:\"id\";s:21:\"site-1-template-14506\";s:4:\"name\";s:4:\"Blog\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page08-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14506.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:51:\"https://templates.ultimatebeaver.com/template/blog/\";}s:21:\"site-1-template-14497\";a:7:{s:2:\"id\";s:21:\"site-1-template-14497\";s:4:\"name\";s:14:\"Beauty Parlour\";s:5:\"image\";s:110:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/beautyparlour-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14497.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:61:\"https://templates.ultimatebeaver.com/template/beauty-parlour/\";}s:21:\"site-1-template-14423\";a:7:{s:2:\"id\";s:21:\"site-1-template-14423\";s:4:\"name\";s:19:\"Blog offering Ebook\";s:5:\"image\";s:113:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/landing-page09-free-img-1-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14423.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/blog-ebook/\";}s:21:\"site-1-template-14351\";a:7:{s:2:\"id\";s:21:\"site-1-template-14351\";s:4:\"name\";s:12:\"Service Page\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2017/01/saevice-page-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14351.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/service/\";}s:21:\"site-1-template-14223\";a:7:{s:2:\"id\";s:21:\"site-1-template-14223\";s:4:\"name\";s:13:\"Special Offer\";s:5:\"image\";s:123:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/special-offer-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14223.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/special-offer/\";}s:21:\"site-1-template-14189\";a:7:{s:2:\"id\";s:21:\"site-1-template-14189\";s:4:\"name\";s:11:\"Coming soon\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/landing-page16-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14189.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/coming-soon/\";}s:21:\"site-1-template-14130\";a:7:{s:2:\"id\";s:21:\"site-1-template-14130\";s:4:\"name\";s:16:\"Coming Soon Page\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/landing-page17-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14130.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:60:\"https://templates.ultimatebeaver.com/template/coming-soon-2/\";}s:21:\"site-1-template-14110\";a:7:{s:2:\"id\";s:21:\"site-1-template-14110\";s:4:\"name\";s:27:\"Introduce Product / Service\";s:5:\"image\";s:104:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/webinar-free-img-400x400.png\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14110.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/template/introduce-product/\";}s:21:\"site-1-template-14058\";a:7:{s:2:\"id\";s:21:\"site-1-template-14058\";s:4:\"name\";s:10:\"Free Ebook\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/landing-page33-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14058.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/free-ebook/\";}s:21:\"site-1-template-14016\";a:7:{s:2:\"id\";s:21:\"site-1-template-14016\";s:4:\"name\";s:10:\"Restaurant\";s:5:\"image\";s:120:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/restaurant-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-14016.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/restaurant/\";}s:21:\"site-1-template-13939\";a:7:{s:2:\"id\";s:21:\"site-1-template-13939\";s:4:\"name\";s:11:\"Watch Store\";s:5:\"image\";s:121:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/watch-store-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-13939.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/watch-store/\";}s:21:\"site-1-template-13927\";a:7:{s:2:\"id\";s:21:\"site-1-template-13927\";s:4:\"name\";s:19:\"Subscription Signup\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/subscription-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-13927.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/template/subscription-signup/\";}s:21:\"site-1-template-13925\";a:7:{s:2:\"id\";s:21:\"site-1-template-13925\";s:4:\"name\";s:16:\"Yoga and Fitness\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/yoga-fitness-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-13925.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:51:\"https://templates.ultimatebeaver.com/template/yoga/\";}s:21:\"site-1-template-13924\";a:7:{s:2:\"id\";s:21:\"site-1-template-13924\";s:4:\"name\";s:15:\"E-book or Guide\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/12/landing-page23-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-13924.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:53:\"https://templates.ultimatebeaver.com/template/e-book/\";}s:21:\"site-1-template-12269\";a:7:{s:2:\"id\";s:21:\"site-1-template-12269\";s:4:\"name\";s:10:\"Contact 06\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact06-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12269.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-06/\";}s:21:\"site-1-template-12267\";a:7:{s:2:\"id\";s:21:\"site-1-template-12267\";s:4:\"name\";s:8:\"About 02\";s:5:\"image\";s:95:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/about02-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12267.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:55:\"https://templates.ultimatebeaver.com/template/about-02/\";}s:21:\"site-1-template-12265\";a:7:{s:2:\"id\";s:21:\"site-1-template-12265\";s:4:\"name\";s:7:\"Team 04\";s:5:\"image\";s:107:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/team04-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12265.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/team-04/\";}s:21:\"site-1-template-12263\";a:7:{s:2:\"id\";s:21:\"site-1-template-12263\";s:4:\"name\";s:10:\"Join Us 04\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/joinus04-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12263.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"Join Us\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/join-us-04/\";}s:21:\"site-1-template-12261\";a:7:{s:2:\"id\";s:21:\"site-1-template-12261\";s:4:\"name\";s:10:\"Join Us 03\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/joinus03-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12261.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"Join Us\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/join-us-03/\";}s:21:\"site-1-template-12259\";a:7:{s:2:\"id\";s:21:\"site-1-template-12259\";s:4:\"name\";s:10:\"Join Us 02\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/joinus02-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12259.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"Join Us\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/join-us-02/\";}s:21:\"site-1-template-12257\";a:7:{s:2:\"id\";s:21:\"site-1-template-12257\";s:4:\"name\";s:10:\"Join Us 01\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/joinus01-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12257.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"Join Us\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/join-us-01/\";}s:21:\"site-1-template-12255\";a:7:{s:2:\"id\";s:21:\"site-1-template-12255\";s:4:\"name\";s:10:\"Contact 05\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact05-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12255.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-05/\";}s:21:\"site-1-template-12253\";a:7:{s:2:\"id\";s:21:\"site-1-template-12253\";s:4:\"name\";s:10:\"Contact 04\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact04-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12253.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-04/\";}s:21:\"site-1-template-12251\";a:7:{s:2:\"id\";s:21:\"site-1-template-12251\";s:4:\"name\";s:10:\"Contact 03\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact03-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12251.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-03/\";}s:21:\"site-1-template-12249\";a:7:{s:2:\"id\";s:21:\"site-1-template-12249\";s:4:\"name\";s:10:\"Contact 02\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact02-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12249.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-02/\";}s:21:\"site-1-template-12247\";a:7:{s:2:\"id\";s:21:\"site-1-template-12247\";s:4:\"name\";s:10:\"Contact 01\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/contact01-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12247.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:57:\"https://templates.ultimatebeaver.com/template/contact-01/\";}s:21:\"site-1-template-12245\";a:7:{s:2:\"id\";s:21:\"site-1-template-12245\";s:4:\"name\";s:7:\"FAQs 02\";s:5:\"image\";s:102:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/faq02-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12245.dat\";s:4:\"tags\";a:1:{i:0;s:4:\"FAQs\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/faqs-02/\";}s:21:\"site-1-template-12243\";a:7:{s:2:\"id\";s:21:\"site-1-template-12243\";s:4:\"name\";s:7:\"FAQs 03\";s:5:\"image\";s:102:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/faq03-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12243.dat\";s:4:\"tags\";a:1:{i:0;s:4:\"FAQs\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/faqs-03/\";}s:21:\"site-1-template-12241\";a:7:{s:2:\"id\";s:21:\"site-1-template-12241\";s:4:\"name\";s:7:\"FAQs 01\";s:5:\"image\";s:93:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/faq01-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12241.dat\";s:4:\"tags\";a:1:{i:0;s:4:\"FAQs\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/faqs-01/\";}s:21:\"site-1-template-12239\";a:7:{s:2:\"id\";s:21:\"site-1-template-12239\";s:4:\"name\";s:12:\"Offerings 01\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/offering-1-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12239.dat\";s:4:\"tags\";a:1:{i:0;s:8:\"services\";}s:11:\"preview_url\";s:59:\"https://templates.ultimatebeaver.com/template/offerings-01/\";}s:21:\"site-1-template-12237\";a:7:{s:2:\"id\";s:21:\"site-1-template-12237\";s:4:\"name\";s:11:\"Features 01\";s:5:\"image\";s:97:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/feature01-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12237.dat\";s:4:\"tags\";a:1:{i:0;s:8:\"services\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/features-01/\";}s:21:\"site-1-template-12235\";a:7:{s:2:\"id\";s:21:\"site-1-template-12235\";s:4:\"name\";s:11:\"Services 01\";s:5:\"image\";s:115:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/saevice01-page-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12235.dat\";s:4:\"tags\";a:1:{i:0;s:8:\"services\";}s:11:\"preview_url\";s:58:\"https://templates.ultimatebeaver.com/template/services-01/\";}s:21:\"site-1-template-12233\";a:7:{s:2:\"id\";s:21:\"site-1-template-12233\";s:4:\"name\";s:25:\"Lead Generation Funnel 01\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/landing-page41-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12233.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:72:\"https://templates.ultimatebeaver.com/template/lead-generation-funnel-01/\";}s:21:\"site-1-template-12231\";a:7:{s:2:\"id\";s:21:\"site-1-template-12231\";s:4:\"name\";s:24:\"Business Landing Page 03\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/landing-page13-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12231.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:71:\"https://templates.ultimatebeaver.com/template/business-landing-page-03/\";}s:21:\"site-1-template-12229\";a:7:{s:2:\"id\";s:21:\"site-1-template-12229\";s:4:\"name\";s:24:\"Business Landing Page 02\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/landing-page12-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12229.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:71:\"https://templates.ultimatebeaver.com/template/business-landing-page-02/\";}s:21:\"site-1-template-12227\";a:7:{s:2:\"id\";s:21:\"site-1-template-12227\";s:4:\"name\";s:24:\"Business Landing Page 01\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/landing-page11-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12227.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:71:\"https://templates.ultimatebeaver.com/template/business-landing-page-01/\";}s:21:\"site-1-template-12225\";a:7:{s:2:\"id\";s:21:\"site-1-template-12225\";s:4:\"name\";s:24:\"Features Landing Page 01\";s:5:\"image\";s:111:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/landing-page28-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12225.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:71:\"https://templates.ultimatebeaver.com/template/features-landing-page-01/\";}s:21:\"site-1-template-12223\";a:7:{s:2:\"id\";s:21:\"site-1-template-12223\";s:4:\"name\";s:18:\"Plans & Pricing 01\";s:5:\"image\";s:128:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/Plans-Pricing-01-landing-page-free-img-1-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12223.dat\";s:4:\"tags\";a:1:{i:0;s:13:\"landing pages\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/template/plans-pricing-01/\";}s:21:\"site-1-template-12219\";a:7:{s:2:\"id\";s:21:\"site-1-template-12219\";s:4:\"name\";s:7:\"Team 03\";s:5:\"image\";s:107:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/team03-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12219.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/team-03/\";}s:21:\"site-1-template-12217\";a:7:{s:2:\"id\";s:21:\"site-1-template-12217\";s:4:\"name\";s:7:\"Team 02\";s:5:\"image\";s:107:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/team02-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12217.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/team-02/\";}s:21:\"site-1-template-12215\";a:7:{s:2:\"id\";s:21:\"site-1-template-12215\";s:4:\"name\";s:7:\"Team 01\";s:5:\"image\";s:107:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/team01-landing-page-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12215.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:54:\"https://templates.ultimatebeaver.com/template/team-01/\";}s:21:\"site-1-template-12213\";a:7:{s:2:\"id\";s:21:\"site-1-template-12213\";s:4:\"name\";s:8:\"About 01\";s:5:\"image\";s:103:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/about01free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12213.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:55:\"https://templates.ultimatebeaver.com/template/about-01/\";}s:21:\"site-1-template-12084\";a:7:{s:2:\"id\";s:21:\"site-1-template-12084\";s:4:\"name\";s:8:\"About 05\";s:5:\"image\";s:95:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/about03-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:99:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-template-12084.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:55:\"https://templates.ultimatebeaver.com/template/about-05/\";}s:18:\"site-6-template-53\";a:7:{s:2:\"id\";s:18:\"site-6-template-53\";s:4:\"name\";s:10:\"Veterinary\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/6/2016/10/veternory-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-6-template-53.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:68:\"https://templates.ultimatebeaver.com/veterinary/template/veterinary/\";}s:18:\"site-7-template-34\";a:7:{s:2:\"id\";s:18:\"site-7-template-34\";s:4:\"name\";s:13:\"Paediatrician\";s:5:\"image\";s:109:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/7/2016/10/Paediatrician-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-7-template-34.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:74:\"https://templates.ultimatebeaver.com/paediatrician/template/paediatrician/\";}s:18:\"site-8-template-47\";a:7:{s:2:\"id\";s:18:\"site-8-template-47\";s:4:\"name\";s:18:\"Science Laboratory\";s:5:\"image\";s:125:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/8/2016/11/science-landing-page-free-img-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:108:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/bb-ultimate-addon/site-8-template-47.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:90:\"https://templates.ultimatebeaver.com/science-laboratory/template/science-laboratory-wtest/\";}s:19:\"site-9-template-400\";a:7:{s:2:\"id\";s:19:\"site-9-template-400\";s:4:\"name\";s:11:\"Services 02\";s:5:\"image\";s:116:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/9/2016/09/services-02-free-img-329x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-9-template-400.dat\";s:4:\"tags\";a:1:{i:0;s:23:\"Features &amp; Services\";}s:11:\"preview_url\";s:67:\"https://templates.ultimatebeaver.com/gardener/template/services-02/\";}s:19:\"site-9-template-391\";a:7:{s:2:\"id\";s:19:\"site-9-template-391\";s:4:\"name\";s:8:\"Gardener\";s:5:\"image\";s:103:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/9/2016/09/Gardner-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-9-template-391.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/gardener/template/gardener/\";}s:19:\"site-9-template-355\";a:7:{s:2:\"id\";s:19:\"site-9-template-355\";s:4:\"name\";s:7:\"FAQs 04\";s:5:\"image\";s:102:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/9/2016/09/faq-04-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-9-template-355.dat\";s:4:\"tags\";a:1:{i:0;s:4:\"FAQs\";}s:11:\"preview_url\";s:63:\"https://templates.ultimatebeaver.com/gardener/template/faqs-04/\";}s:19:\"site-9-template-354\";a:7:{s:2:\"id\";s:19:\"site-9-template-354\";s:4:\"name\";s:8:\"About 03\";s:5:\"image\";s:103:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/9/2016/09/about03-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-9-template-354.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/gardener/template/about-03/\";}s:19:\"site-9-template-339\";a:7:{s:2:\"id\";s:19:\"site-9-template-339\";s:4:\"name\";s:10:\"Contact 07\";s:5:\"image\";s:105:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/9/2016/09/contact07-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-9-template-339.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/gardener/template/contact-07/\";}s:20:\"site-10-template-364\";a:7:{s:2:\"id\";s:20:\"site-10-template-364\";s:4:\"name\";s:10:\"Contact 08\";s:5:\"image\";s:106:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/10/2016/10/contact08-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:98:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-10-template-364.dat\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}s:11:\"preview_url\";s:68:\"https://templates.ultimatebeaver.com/life-coach/template/contact-08/\";}s:20:\"site-10-template-363\";a:7:{s:2:\"id\";s:20:\"site-10-template-363\";s:4:\"name\";s:7:\"FAQs 05\";s:5:\"image\";s:102:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/10/2016/10/faq05-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:98:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-10-template-363.dat\";s:4:\"tags\";a:1:{i:0;s:4:\"FAQs\";}s:11:\"preview_url\";s:65:\"https://templates.ultimatebeaver.com/life-coach/template/faqs-05/\";}s:20:\"site-10-template-362\";a:7:{s:2:\"id\";s:20:\"site-10-template-362\";s:4:\"name\";s:8:\"About 04\";s:5:\"image\";s:104:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/10/2016/10/about04-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:98:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-10-template-362.dat\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/life-coach/template/about-04/\";}s:19:\"site-11-template-56\";a:7:{s:2:\"id\";s:19:\"site-11-template-56\";s:4:\"name\";s:7:\"Builder\";s:5:\"image\";s:104:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/11/2016/09/Builder-400x400.jpg\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-11-template-56.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:62:\"https://templates.ultimatebeaver.com/builder/template/builder/\";}s:22:\"site-54-template-15530\";a:7:{s:2:\"id\";s:22:\"site-54-template-15530\";s:4:\"name\";s:9:\"Logistics\";s:5:\"image\";s:117:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/54/2017/02/logistics-free-img-1-400x400.png\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:100:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-54-template-15530.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/logistics/template/logistics/\";}s:19:\"site-55-template-89\";a:7:{s:2:\"id\";s:19:\"site-55-template-89\";s:4:\"name\";s:20:\"Grooming and Styling\";s:5:\"image\";s:122:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/sites/55/2017/02/grooming-styling-free-img-400x400.png\";s:4:\"type\";s:6:\"layout\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-55-template-89.dat\";s:4:\"tags\";a:1:{i:0;s:10:\"Home Pages\";}s:11:\"preview_url\";s:80:\"https://templates.ultimatebeaver.com/grooming-styling/template/grooming-styling/\";}}s:8:\"sections\";a:14:{s:18:\"site-1-category-35\";a:7:{s:2:\"id\";s:18:\"site-1-category-35\";s:4:\"name\";s:14:\"Call to Action\";s:5:\"image\";s:92:\"https://downloads.brainstormforce.com/uabb/sections-cloud-watermark/2016/09/228-free-img.jpg\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-35.dat\";s:5:\"count\";i:21;s:11:\"preview_url\";s:74:\"https://templates.ultimatebeaver.com/template-category/row-call-to-action/\";}s:18:\"site-1-category-42\";a:7:{s:2:\"id\";s:18:\"site-1-category-42\";s:4:\"name\";s:12:\"Contact Info\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-42.dat\";s:5:\"count\";i:11;s:11:\"preview_url\";s:72:\"https://templates.ultimatebeaver.com/template-category/row-contact-info/\";}s:18:\"site-1-category-43\";a:7:{s:2:\"id\";s:18:\"site-1-category-43\";s:4:\"name\";s:7:\"Content\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-43.dat\";s:5:\"count\";i:67;s:11:\"preview_url\";s:67:\"https://templates.ultimatebeaver.com/template-category/row-content/\";}s:18:\"site-1-category-52\";a:7:{s:2:\"id\";s:18:\"site-1-category-52\";s:4:\"name\";s:3:\"FAQ\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-52.dat\";s:5:\"count\";i:4;s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/template-category/row-faqs/\";}s:18:\"site-1-category-56\";a:7:{s:2:\"id\";s:18:\"site-1-category-56\";s:4:\"name\";s:8:\"Features\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-56.dat\";s:5:\"count\";i:22;s:11:\"preview_url\";s:68:\"https://templates.ultimatebeaver.com/template-category/row-features/\";}s:18:\"site-1-category-63\";a:7:{s:2:\"id\";s:18:\"site-1-category-63\";s:4:\"name\";s:7:\"Gallery\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-63.dat\";s:5:\"count\";i:2;s:11:\"preview_url\";s:67:\"https://templates.ultimatebeaver.com/template-category/row-gallery/\";}s:18:\"site-1-category-66\";a:7:{s:2:\"id\";s:18:\"site-1-category-66\";s:4:\"name\";s:10:\"Google Map\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-66.dat\";s:5:\"count\";i:3;s:11:\"preview_url\";s:70:\"https://templates.ultimatebeaver.com/template-category/row-google-map/\";}s:18:\"site-1-category-68\";a:7:{s:2:\"id\";s:18:\"site-1-category-68\";s:4:\"name\";s:7:\"Heading\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-68.dat\";s:5:\"count\";i:4;s:11:\"preview_url\";s:67:\"https://templates.ultimatebeaver.com/template-category/row-heading/\";}s:18:\"site-1-category-71\";a:7:{s:2:\"id\";s:18:\"site-1-category-71\";s:4:\"name\";s:4:\"Hero\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-71.dat\";s:5:\"count\";i:6;s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/template-category/row-hero/\";}s:18:\"site-1-category-87\";a:7:{s:2:\"id\";s:18:\"site-1-category-87\";s:4:\"name\";s:5:\"Logos\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-87.dat\";s:5:\"count\";i:20;s:11:\"preview_url\";s:65:\"https://templates.ultimatebeaver.com/template-category/row-logos/\";}s:18:\"site-1-category-93\";a:7:{s:2:\"id\";s:18:\"site-1-category-93\";s:4:\"name\";s:6:\"Number\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:96:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-93.dat\";s:5:\"count\";i:15;s:11:\"preview_url\";s:66:\"https://templates.ultimatebeaver.com/template-category/row-number/\";}s:19:\"site-1-category-113\";a:7:{s:2:\"id\";s:19:\"site-1-category-113\";s:4:\"name\";s:14:\"Subscribe Form\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-113.dat\";s:5:\"count\";i:6;s:11:\"preview_url\";s:69:\"https://templates.ultimatebeaver.com/template-category/row-subscribe/\";}s:19:\"site-1-category-114\";a:7:{s:2:\"id\";s:19:\"site-1-category-114\";s:4:\"name\";s:4:\"Team\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-114.dat\";s:5:\"count\";i:7;s:11:\"preview_url\";s:64:\"https://templates.ultimatebeaver.com/template-category/row-team/\";}s:19:\"site-1-category-119\";a:7:{s:2:\"id\";s:19:\"site-1-category-119\";s:4:\"name\";s:12:\"Testimonials\";s:5:\"image\";s:0:\"\";s:4:\"type\";s:3:\"row\";s:7:\"dat_url\";s:97:\"https://templates.ultimatebeaver.com/wp-content/uploads/bb-ultimate-addon/site-1-category-119.dat\";s:5:\"count\";i:6;s:11:\"preview_url\";s:72:\"https://templates.ultimatebeaver.com/template-category/row-testimonials/\";}}}", "no");
INSERT INTO `wptj_options` VALUES("177", "bsf_skip_braisntorm_menu", "1", "no");
INSERT INTO `wptj_options` VALUES("175", "brainstrom_bundled_products", "a:0:{}", "yes");
INSERT INTO `wptj_options` VALUES("180", "uabb_cloud_templates", "1558573994", "yes");
INSERT INTO `wptj_options` VALUES("441", "astra_theme_css_key-astra-addon", "5cf1291d6be084-06134309", "yes");
INSERT INTO `wptj_options` VALUES("442", "astra_theme_js_key-dep-astra-addon", "a:1:{s:6:\"jquery\";N;}", "yes");
INSERT INTO `wptj_options` VALUES("443", "astra_theme_js_key-astra-addon", "5cf1291d6c4ce7-68694229", "yes");
INSERT INTO `wptj_options` VALUES("186", "_astra_ext_enabled_extensions", "a:18:{s:14:\"advanced-hooks\";s:14:\"advanced-hooks\";s:8:\"blog-pro\";s:8:\"blog-pro\";s:21:\"colors-and-background\";s:21:\"colors-and-background\";s:15:\"advanced-footer\";s:15:\"advanced-footer\";s:13:\"mobile-header\";s:13:\"mobile-header\";s:15:\"header-sections\";s:15:\"header-sections\";s:9:\"lifterlms\";s:9:\"lifterlms\";s:9:\"learndash\";s:9:\"learndash\";s:16:\"advanced-headers\";s:16:\"advanced-headers\";s:12:\"site-layouts\";s:12:\"site-layouts\";s:7:\"spacing\";s:7:\"spacing\";s:13:\"sticky-header\";s:13:\"sticky-header\";s:13:\"scroll-to-top\";s:13:\"scroll-to-top\";s:18:\"transparent-header\";s:18:\"transparent-header\";s:10:\"typography\";s:10:\"typography\";s:11:\"woocommerce\";s:11:\"woocommerce\";s:3:\"edd\";s:3:\"edd\";s:8:\"nav-menu\";s:8:\"nav-menu\";}", "yes");
INSERT INTO `wptj_options` VALUES("187", "_astra_ext_http2", "1", "yes");
INSERT INTO `wptj_options` VALUES("197", "_fl_builder_uabb", "a:4:{s:18:\"uabb-row-separator\";b:1;s:17:\"uabb-row-gradient\";b:1;s:17:\"uabb-col-gradient\";b:1;s:15:\"uabb-col-shadow\";b:1;}", "yes");
INSERT INTO `wptj_options` VALUES("198", "_fl_builder_uabb_modules", "a:52:{s:3:\"all\";s:3:\"all\";s:18:\"advanced-accordion\";s:18:\"advanced-accordion\";s:13:\"advanced-icon\";s:13:\"advanced-icon\";s:18:\"uabb-advanced-menu\";s:18:\"uabb-advanced-menu\";s:10:\"blog-posts\";s:10:\"blog-posts\";s:13:\"advanced-tabs\";s:13:\"advanced-tabs\";s:22:\"uabb-beforeafterslider\";s:22:\"uabb-beforeafterslider\";s:19:\"uabb-business-hours\";s:19:\"uabb-business-hours\";s:19:\"uabb-call-to-action\";s:19:\"uabb-call-to-action\";s:17:\"uabb-contact-form\";s:17:\"uabb-contact-form\";s:19:\"uabb-content-toggle\";s:19:\"uabb-content-toggle\";s:14:\"uabb-countdown\";s:14:\"uabb-countdown\";s:12:\"uabb-numbers\";s:12:\"uabb-numbers\";s:13:\"creative-link\";s:13:\"creative-link\";s:11:\"dual-button\";s:11:\"dual-button\";s:18:\"dual-color-heading\";s:18:\"dual-color-heading\";s:10:\"fancy-text\";s:10:\"fancy-text\";s:8:\"flip-box\";s:8:\"flip-box\";s:10:\"google-map\";s:10:\"google-map\";s:12:\"uabb-heading\";s:12:\"uabb-heading\";s:12:\"uabb-hotspot\";s:12:\"uabb-hotspot\";s:6:\"ihover\";s:6:\"ihover\";s:19:\"uabb-image-carousel\";s:19:\"uabb-image-carousel\";s:15:\"image-separator\";s:15:\"image-separator\";s:11:\"info-banner\";s:11:\"info-banner\";s:8:\"info-box\";s:8:\"info-box\";s:11:\"info-circle\";s:11:\"info-circle\";s:9:\"info-list\";s:9:\"info-list\";s:10:\"info-table\";s:10:\"info-table\";s:20:\"interactive-banner-1\";s:20:\"interactive-banner-1\";s:20:\"interactive-banner-2\";s:20:\"interactive-banner-2\";s:9:\"list-icon\";s:9:\"list-icon\";s:24:\"mailchimp-subscribe-form\";s:24:\"mailchimp-subscribe-form\";s:11:\"modal-popup\";s:11:\"modal-popup\";s:10:\"uabb-photo\";s:10:\"uabb-photo\";s:13:\"photo-gallery\";s:13:\"photo-gallery\";s:11:\"pricing-box\";s:11:\"pricing-box\";s:15:\"uabb-price-list\";s:15:\"uabb-price-list\";s:12:\"progress-bar\";s:12:\"progress-bar\";s:6:\"ribbon\";s:6:\"ribbon\";s:9:\"slide-box\";s:9:\"slide-box\";s:17:\"uabb-social-share\";s:17:\"uabb-social-share\";s:10:\"spacer-gap\";s:10:\"spacer-gap\";s:10:\"uabb-table\";s:10:\"uabb-table\";s:4:\"team\";s:4:\"team\";s:16:\"adv-testimonials\";s:16:\"adv-testimonials\";s:10:\"uabb-video\";s:10:\"uabb-video\";s:18:\"uabb-video-gallery\";s:18:\"uabb-video-gallery\";s:18:\"advanced-separator\";s:18:\"advanced-separator\";s:11:\"uabb-button\";s:11:\"uabb-button\";s:10:\"image-icon\";s:10:\"image-icon\";s:14:\"uabb-separator\";s:14:\"uabb-separator\";}", "yes");
INSERT INTO `wptj_options` VALUES("199", "edd_sl_002b68818e7b8a81b7f6dfe75243c2ea", "a:2:{s:7:\"timeout\";i:1565827991;s:5:\"value\";s:925:\"{\"new_version\":\"2.7.3\",\"stable_version\":\"2.7.3\",\"name\":\"PowerPack for Beaver Builder\",\"slug\":\"bb-powerpack\",\"url\":\"https:\\/\\/wpbeaveraddons.com\\/downloads\\/powerpack\\/?changelog=1\",\"last_updated\":\"2019-08-12 00:33:30\",\"homepage\":\"https:\\/\\/wpbeaveraddons.com\\/downloads\\/powerpack\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p>PowerPack is a set of custom\\u00a0modules and templates for Beaver Builder.<\\/p>\\n\",\"changelog\":\"<p>Please check the <a href=\\\"https:\\/\\/wpbeaveraddons.com\\/change-logs\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">changelog page<\\/a> for all the details.<\\/p>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":[],\"description\":[\"<p>PowerPack is a set of custom\\u00a0modules and templates for Beaver Builder.<\\/p>\\n\"],\"changelog\":[\"<p>Please check the <a href=\\\"https:\\/\\/wpbeaveraddons.com\\/change-logs\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">changelog page<\\/a> for all the details.<\\/p>\\n\"]}\";}", "no");
INSERT INTO `wptj_options` VALUES("212", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wptj_options` VALUES("309", "bbhf_settings", "a:5:{s:12:\"bb_header_id\";s:0:\"\";s:12:\"bb_footer_id\";s:2:\"47\";s:21:\"bb_transparent_header\";s:3:\"off\";s:16:\"bb_sticky_header\";s:3:\"off\";s:16:\"bb_shrink_header\";s:2:\"on\";}", "yes");
INSERT INTO `wptj_options` VALUES("424", "astra_theme_js_key-dep-ast-customizer", "a:1:{s:6:\"jquery\";N;}", "yes");
INSERT INTO `wptj_options` VALUES("425", "astra_theme_js_key-ast-customizer", "5cf1187a67e4d3-20604429", "yes");
INSERT INTO `wptj_options` VALUES("423", "astra_theme_css_key-ast-customizer", "5cf1187a64d3e5-63568140", "yes");
INSERT INTO `wptj_options` VALUES("613", "_site_transient_timeout_bsf_get_bundled_products", "1566421989", "no");
INSERT INTO `wptj_options` VALUES("614", "_site_transient_bsf_get_bundled_products", "1", "no");

/* INSERT TABLE DATA: wptj_postmeta */
INSERT INTO `wptj_postmeta` VALUES("3", "5", "_uabb_version", "1.16.5");
INSERT INTO `wptj_postmeta` VALUES("4", "5", "_edit_lock", "1558573980:1");
INSERT INTO `wptj_postmeta` VALUES("5", "5", "_edit_last", "1");
INSERT INTO `wptj_postmeta` VALUES("6", "5", "site-post-title", "disabled");
INSERT INTO `wptj_postmeta` VALUES("7", "5", "site-sidebar-layout", "no-sidebar");
INSERT INTO `wptj_postmeta` VALUES("8", "5", "site-content-layout", "page-builder");
INSERT INTO `wptj_postmeta` VALUES("9", "5", "ast-featured-img", "disabled");
INSERT INTO `wptj_postmeta` VALUES("10", "5", "theme-transparent-header-meta", "default");
INSERT INTO `wptj_postmeta` VALUES("11", "5", "stick-header-meta", "default");
INSERT INTO `wptj_postmeta` VALUES("12", "5", "_fl_builder_draft", "a:36:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:400;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"1\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:1:\"0\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:1:\"0\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:1:\"0\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:1:\"0\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}s:13:\"5ce5db10a9afe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10a9afe\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10aba08\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10aba08\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5db10a9afe\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5db10abb8b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abb8b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbd4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbd4\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbf0\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbf0\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abc34\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abc34\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db1e2fa6f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db1e2fa6f\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abc34\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:268:\"<strong>Acabamento para porta</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567921952_text\";s:0:\"\";}}s:13:\"5ce5db92a4e57\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db92a4e57\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbf0\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:273:\"<strong>Conservação da fechadura</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567901621_text\";s:0:\"\";}}s:13:\"5ce5db93e98f2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db93e98f2\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abb8b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:263:\"<strong>Tipo de Madeiras</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";}}s:13:\"5ce5db94ba6cc\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db94ba6cc\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbd4\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:262:\"<strong>Reflorestamento</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567884328_text\";s:0:\"\";}}s:13:\"5ce5dbf98144f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98144f\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:3:\"-20\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985618\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985618\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dbf98579b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98579b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf9857dd\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf9857dd\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf98581b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98581b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985857\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985857\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4370\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4370\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dc1dd45fe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd45fe\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"21.51\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4651\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4651\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"78.49\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc2598f0e\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc2598f0e\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dc1dd45fe\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:63:\"<span style=\"font-size: 22px;\"><strong>Produtos</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";}}s:13:\"5ce5dc596d8e9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc596d8e9\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf985857\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"12\";s:9:\"photo_src\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:12;s:5:\"title\";s:19:\"acessorios_banheiro\";s:8:\"filename\";s:23:\"acessorios_banheiro.jpg\";s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:4:\"link\";s:56:\"https://siterapidofacil.com/dmk/dmk/acessorios_banheiro/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:19:\"acessorios_banheiro\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568064000;s:8:\"modified\";i:1558568064000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"014c5e5519\";s:6:\"delete\";s:10:\"9dd578d334\";s:4:\"edit\";s:10:\"87b4778bfc\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=12&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:58232;s:21:\"filesizeHumanReadable\";s:5:\"57 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:197;s:5:\"width\";i:300;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-300x197.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9d35876\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9d35876\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98579b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"15\";s:9:\"photo_src\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:15;s:5:\"title\";s:3:\"mdf\";s:8:\"filename\";s:7:\"mdf.jpg\";s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:4:\"link\";s:40:\"https://siterapidofacil.com/dmk/dmk/mdf/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:3:\"mdf\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568070000;s:8:\"modified\";i:1558568070000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"995e7bf2fd\";s:6:\"delete\";s:10:\"5e15dcab89\";s:4:\"edit\";s:10:\"bd4556d6ba\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=15&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:103831;s:21:\"filesizeHumanReadable\";s:6:\"101 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:225;s:5:\"width\";i:300;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-300x225.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9ed8274\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9ed8274\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98581b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"13\";s:9:\"photo_src\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:13;s:5:\"title\";s:14:\"color-vermelho\";s:8:\"filename\";s:18:\"color-vermelho.jpg\";s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:4:\"link\";s:51:\"https://siterapidofacil.com/dmk/dmk/color-vermelho/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:14:\"color-vermelho\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568065000;s:8:\"modified\";i:1558568065000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"2482326a68\";s:6:\"delete\";s:10:\"2fe426a475\";s:4:\"edit\";s:10:\"7b33315df1\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=13&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:62906;s:21:\"filesizeHumanReadable\";s:5:\"61 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:185;s:5:\"width\";i:300;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-300x185.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dca6db0ff\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dca6db0ff\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf9857dd\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"14\";s:9:\"photo_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:14;s:5:\"title\";s:10:\"fechaduras\";s:8:\"filename\";s:14:\"fechaduras.jpg\";s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:4:\"link\";s:47:\"https://siterapidofacil.com/dmk/dmk/fechaduras/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:10:\"fechaduras\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568068000;s:8:\"modified\";i:1558568068000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"17d820d0f3\";s:6:\"delete\";s:10:\"f38f1498e7\";s:4:\"edit\";s:10:\"1ccd950b23\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=14&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:26907;s:21:\"filesizeHumanReadable\";s:5:\"26 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:216;s:5:\"width\";i:300;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-300x216.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5ddc8298a4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddc8298a4\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5ddd7e91d8\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:64:\"<span style=\"font-size: 22px;\"><strong>Parceiros</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";s:24:\"flrich1558568460929_text\";s:0:\"\";}}s:13:\"5ce5ddd7ac3c9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7ac3c9\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7d2147\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7d2147\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5ddd7e91d8\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e91d8\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7e92a2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e92a2\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdd70\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdd70\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5de7ebdeba\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdeba\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5de7ebdd70\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdc88\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdc88\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5de7ebdeba\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":109:{s:12:\"logos_layout\";s:8:\"carousel\";s:18:\"logos_grid_spacing\";s:1:\"5\";s:22:\"logos_carousel_spacing\";s:2:\"15\";s:22:\"upload_logo_show_title\";s:4:\"none\";s:23:\"upload_logo_link_target\";s:5:\"_self\";s:12:\"equal_height\";s:3:\"yes\";s:18:\"logos_grid_columns\";s:1:\"6\";s:25:\"logos_grid_columns_medium\";s:0:\"\";s:29:\"logos_grid_columns_responsive\";s:0:\"\";s:10:\"logos_grid\";a:6:{i:0;O:8:\"stdClass\":7:{s:16:\"upload_logo_grid\";s:2:\"18\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe.jpg\";s:17:\"upload_logo_title\";s:1:\"1\";s:16:\"upload_logo_link\";s:0:\"\";s:1:\"0\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"20\";s:20:\"upload_logo_grid_src\";s:68:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/rocha.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:2;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"19\";s:20:\"upload_logo_grid_src\";s:71:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:3;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"22\";s:20:\"upload_logo_grid_src\";s:65:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/VW.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:4;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"21\";s:20:\"upload_logo_grid_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/schindwein.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:5;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"17\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/concrem.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}}s:19:\"logo_carousel_width\";s:3:\"250\";s:26:\"logo_carousel_minimum_grid\";s:1:\"6\";s:24:\"logo_carousel_move_slide\";s:0:\"\";s:21:\"logo_slider_auto_play\";s:1:\"1\";s:23:\"logo_slider_pause_hover\";s:5:\"false\";s:17:\"logo_slider_pause\";s:1:\"4\";s:22:\"logo_slider_transition\";s:10:\"horizontal\";s:17:\"logo_slider_speed\";s:3:\"0.5\";s:18:\"logo_slider_arrows\";s:1:\"0\";s:16:\"logo_slider_dots\";s:1:\"0\";s:18:\"logo_grid_bg_color\";s:0:\"\";s:18:\"logo_grid_bg_hover\";s:0:\"\";s:17:\"field_separator_1\";s:0:\"\";s:17:\"logo_grid_opacity\";s:3:\"100\";s:23:\"logo_grid_opacity_hover\";s:3:\"100\";s:17:\"field_separator_2\";s:0:\"\";s:16:\"logo_grid_border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:23:\"logo_grid_border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:27:\"logo_grid_border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"field_separator_3\";s:0:\"\";s:19:\"logo_grid_grayscale\";s:8:\"original\";s:25:\"logo_grid_grayscale_hover\";s:8:\"original\";s:27:\"logo_grid_logo_border_style\";s:4:\"none\";s:27:\"logo_grid_logo_border_width\";s:1:\"1\";s:27:\"logo_grid_logo_border_color\";s:0:\"\";s:27:\"logo_grid_logo_border_hover\";s:0:\"\";s:28:\"logo_grid_logo_border_radius\";s:1:\"0\";s:14:\"logo_grid_size\";s:0:\"\";s:26:\"logo_slider_arrow_bg_color\";s:6:\"000000\";s:23:\"logo_slider_arrow_color\";s:6:\"ffffff\";s:29:\"logo_slider_arrow_color_hover\";s:6:\"999999\";s:26:\"logo_slider_arrow_bg_hover\";s:0:\"\";s:25:\"logo_grid_arrow_font_size\";s:2:\"16\";s:32:\"logo_grid_arrow_font_size_medium\";s:0:\"\";s:36:\"logo_grid_arrow_font_size_responsive\";s:0:\"\";s:15:\"logo_grid_arrow\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:22:\"logo_grid_arrow_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:26:\"logo_grid_arrow_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:28:\"logo_grid_arrow_border_hover\";s:0:\"\";s:22:\"logo_grid_dot_bg_color\";s:6:\"f5f5f5\";s:22:\"logo_grid_dot_bg_hover\";s:6:\"999999\";s:19:\"logo_grid_dot_width\";s:2:\"14\";s:27:\"logo_grid_dot_border_radius\";s:3:\"100\";s:16:\"title_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:23:\"title_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:27:\"title_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"logo_grid_title_color\";s:6:\"000000\";s:21:\"logo_grid_title_hover\";s:6:\"666666\";s:26:\"logo_grid_title_top_margin\";s:2:\"10\";s:29:\"logo_grid_title_bottom_margin\";s:2:\"10\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:21:\"logo_grid_padding_top\";s:1:\"0\";s:28:\"logo_grid_padding_top_medium\";s:0:\"\";s:32:\"logo_grid_padding_top_responsive\";s:0:\"\";s:23:\"logo_grid_padding_right\";s:1:\"0\";s:30:\"logo_grid_padding_right_medium\";s:0:\"\";s:34:\"logo_grid_padding_right_responsive\";s:0:\"\";s:24:\"logo_grid_padding_bottom\";s:1:\"0\";s:31:\"logo_grid_padding_bottom_medium\";s:0:\"\";s:35:\"logo_grid_padding_bottom_responsive\";s:0:\"\";s:22:\"logo_grid_padding_left\";s:1:\"0\";s:29:\"logo_grid_padding_left_medium\";s:0:\"\";s:33:\"logo_grid_padding_left_responsive\";s:0:\"\";s:27:\"logo_grid_arrow_padding_top\";s:1:\"0\";s:34:\"logo_grid_arrow_padding_top_medium\";s:0:\"\";s:38:\"logo_grid_arrow_padding_top_responsive\";s:0:\"\";s:29:\"logo_grid_arrow_padding_right\";s:1:\"0\";s:36:\"logo_grid_arrow_padding_right_medium\";s:0:\"\";s:40:\"logo_grid_arrow_padding_right_responsive\";s:0:\"\";s:30:\"logo_grid_arrow_padding_bottom\";s:1:\"0\";s:37:\"logo_grid_arrow_padding_bottom_medium\";s:0:\"\";s:41:\"logo_grid_arrow_padding_bottom_responsive\";s:0:\"\";s:28:\"logo_grid_arrow_padding_left\";s:1:\"0\";s:35:\"logo_grid_arrow_padding_left_medium\";s:0:\"\";s:39:\"logo_grid_arrow_padding_left_responsive\";s:0:\"\";s:10:\"margin_top\";s:3:\"-80\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:13:\"pp-logos-grid\";s:17:\"logo_grid_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:23:\"logo_grid_arrow_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}}}}");
INSERT INTO `wptj_postmeta` VALUES("13", "5", "_fl_builder_draft_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("20", "5", "_fl_builder_data", "a:36:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:400;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"1\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:1:\"0\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:1:\"0\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:1:\"0\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:1:\"0\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}s:13:\"5ce5db10a9afe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10a9afe\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10aba08\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10aba08\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5db10a9afe\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5db10abb8b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abb8b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbd4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbd4\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbf0\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbf0\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abc34\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abc34\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db1e2fa6f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db1e2fa6f\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abc34\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:268:\"<strong>Acabamento para porta</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567921952_text\";s:0:\"\";}}s:13:\"5ce5db92a4e57\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db92a4e57\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbf0\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:273:\"<strong>Conservação da fechadura</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567901621_text\";s:0:\"\";}}s:13:\"5ce5db93e98f2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db93e98f2\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abb8b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:263:\"<strong>Tipo de Madeiras</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";}}s:13:\"5ce5db94ba6cc\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db94ba6cc\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbd4\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:262:\"<strong>Reflorestamento</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567884328_text\";s:0:\"\";}}s:13:\"5ce5dbf98144f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98144f\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:3:\"-20\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985618\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985618\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dbf98579b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98579b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf9857dd\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf9857dd\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf98581b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98581b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985857\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985857\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4370\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4370\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dc1dd45fe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd45fe\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"21.51\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4651\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4651\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"78.49\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc2598f0e\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc2598f0e\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dc1dd45fe\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:63:\"<span style=\"font-size: 22px;\"><strong>Produtos</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";}}s:13:\"5ce5dc596d8e9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc596d8e9\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf985857\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"12\";s:9:\"photo_src\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:12;s:5:\"title\";s:19:\"acessorios_banheiro\";s:8:\"filename\";s:23:\"acessorios_banheiro.jpg\";s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:4:\"link\";s:56:\"https://siterapidofacil.com/dmk/dmk/acessorios_banheiro/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:19:\"acessorios_banheiro\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568064000;s:8:\"modified\";i:1558568064000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"014c5e5519\";s:6:\"delete\";s:10:\"9dd578d334\";s:4:\"edit\";s:10:\"87b4778bfc\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=12&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:58232;s:21:\"filesizeHumanReadable\";s:5:\"57 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:197;s:5:\"width\";i:300;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-300x197.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9d35876\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9d35876\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98579b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"15\";s:9:\"photo_src\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:15;s:5:\"title\";s:3:\"mdf\";s:8:\"filename\";s:7:\"mdf.jpg\";s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:4:\"link\";s:40:\"https://siterapidofacil.com/dmk/dmk/mdf/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:3:\"mdf\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568070000;s:8:\"modified\";i:1558568070000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"995e7bf2fd\";s:6:\"delete\";s:10:\"5e15dcab89\";s:4:\"edit\";s:10:\"bd4556d6ba\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=15&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:103831;s:21:\"filesizeHumanReadable\";s:6:\"101 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:225;s:5:\"width\";i:300;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-300x225.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9ed8274\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9ed8274\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98581b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"13\";s:9:\"photo_src\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:13;s:5:\"title\";s:14:\"color-vermelho\";s:8:\"filename\";s:18:\"color-vermelho.jpg\";s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:4:\"link\";s:51:\"https://siterapidofacil.com/dmk/dmk/color-vermelho/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:14:\"color-vermelho\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568065000;s:8:\"modified\";i:1558568065000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"2482326a68\";s:6:\"delete\";s:10:\"2fe426a475\";s:4:\"edit\";s:10:\"7b33315df1\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=13&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:62906;s:21:\"filesizeHumanReadable\";s:5:\"61 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:185;s:5:\"width\";i:300;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-300x185.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dca6db0ff\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dca6db0ff\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf9857dd\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"14\";s:9:\"photo_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:14;s:5:\"title\";s:10:\"fechaduras\";s:8:\"filename\";s:14:\"fechaduras.jpg\";s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:4:\"link\";s:47:\"https://siterapidofacil.com/dmk/dmk/fechaduras/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:10:\"fechaduras\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568068000;s:8:\"modified\";i:1558568068000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"17d820d0f3\";s:6:\"delete\";s:10:\"f38f1498e7\";s:4:\"edit\";s:10:\"1ccd950b23\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=14&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:26907;s:21:\"filesizeHumanReadable\";s:5:\"26 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:216;s:5:\"width\";i:300;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-300x216.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5ddc8298a4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddc8298a4\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5ddd7e91d8\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:64:\"<span style=\"font-size: 22px;\"><strong>Parceiros</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";s:24:\"flrich1558568460929_text\";s:0:\"\";}}s:13:\"5ce5ddd7ac3c9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7ac3c9\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7d2147\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7d2147\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5ddd7e91d8\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e91d8\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7e92a2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e92a2\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdd70\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdd70\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5de7ebdeba\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdeba\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5de7ebdd70\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdc88\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdc88\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5de7ebdeba\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":109:{s:12:\"logos_layout\";s:8:\"carousel\";s:18:\"logos_grid_spacing\";s:1:\"5\";s:22:\"logos_carousel_spacing\";s:2:\"15\";s:22:\"upload_logo_show_title\";s:4:\"none\";s:23:\"upload_logo_link_target\";s:5:\"_self\";s:12:\"equal_height\";s:3:\"yes\";s:18:\"logos_grid_columns\";s:1:\"6\";s:25:\"logos_grid_columns_medium\";s:0:\"\";s:29:\"logos_grid_columns_responsive\";s:0:\"\";s:10:\"logos_grid\";a:6:{i:0;O:8:\"stdClass\":7:{s:16:\"upload_logo_grid\";s:2:\"18\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe.jpg\";s:17:\"upload_logo_title\";s:1:\"1\";s:16:\"upload_logo_link\";s:0:\"\";s:1:\"0\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"20\";s:20:\"upload_logo_grid_src\";s:68:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/rocha.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:2;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"19\";s:20:\"upload_logo_grid_src\";s:71:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:3;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"22\";s:20:\"upload_logo_grid_src\";s:65:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/VW.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:4;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"21\";s:20:\"upload_logo_grid_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/schindwein.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:5;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"17\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/concrem.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}}s:19:\"logo_carousel_width\";s:3:\"250\";s:26:\"logo_carousel_minimum_grid\";s:1:\"6\";s:24:\"logo_carousel_move_slide\";s:0:\"\";s:21:\"logo_slider_auto_play\";s:1:\"1\";s:23:\"logo_slider_pause_hover\";s:5:\"false\";s:17:\"logo_slider_pause\";s:1:\"4\";s:22:\"logo_slider_transition\";s:10:\"horizontal\";s:17:\"logo_slider_speed\";s:3:\"0.5\";s:18:\"logo_slider_arrows\";s:1:\"0\";s:16:\"logo_slider_dots\";s:1:\"0\";s:18:\"logo_grid_bg_color\";s:0:\"\";s:18:\"logo_grid_bg_hover\";s:0:\"\";s:17:\"field_separator_1\";s:0:\"\";s:17:\"logo_grid_opacity\";s:3:\"100\";s:23:\"logo_grid_opacity_hover\";s:3:\"100\";s:17:\"field_separator_2\";s:0:\"\";s:16:\"logo_grid_border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:23:\"logo_grid_border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:27:\"logo_grid_border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"field_separator_3\";s:0:\"\";s:19:\"logo_grid_grayscale\";s:8:\"original\";s:25:\"logo_grid_grayscale_hover\";s:8:\"original\";s:27:\"logo_grid_logo_border_style\";s:4:\"none\";s:27:\"logo_grid_logo_border_width\";s:1:\"1\";s:27:\"logo_grid_logo_border_color\";s:0:\"\";s:27:\"logo_grid_logo_border_hover\";s:0:\"\";s:28:\"logo_grid_logo_border_radius\";s:1:\"0\";s:14:\"logo_grid_size\";s:0:\"\";s:26:\"logo_slider_arrow_bg_color\";s:6:\"000000\";s:23:\"logo_slider_arrow_color\";s:6:\"ffffff\";s:29:\"logo_slider_arrow_color_hover\";s:6:\"999999\";s:26:\"logo_slider_arrow_bg_hover\";s:0:\"\";s:25:\"logo_grid_arrow_font_size\";s:2:\"16\";s:32:\"logo_grid_arrow_font_size_medium\";s:0:\"\";s:36:\"logo_grid_arrow_font_size_responsive\";s:0:\"\";s:15:\"logo_grid_arrow\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:22:\"logo_grid_arrow_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:26:\"logo_grid_arrow_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:28:\"logo_grid_arrow_border_hover\";s:0:\"\";s:22:\"logo_grid_dot_bg_color\";s:6:\"f5f5f5\";s:22:\"logo_grid_dot_bg_hover\";s:6:\"999999\";s:19:\"logo_grid_dot_width\";s:2:\"14\";s:27:\"logo_grid_dot_border_radius\";s:3:\"100\";s:16:\"title_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:23:\"title_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:27:\"title_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"logo_grid_title_color\";s:6:\"000000\";s:21:\"logo_grid_title_hover\";s:6:\"666666\";s:26:\"logo_grid_title_top_margin\";s:2:\"10\";s:29:\"logo_grid_title_bottom_margin\";s:2:\"10\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:21:\"logo_grid_padding_top\";s:1:\"0\";s:28:\"logo_grid_padding_top_medium\";s:0:\"\";s:32:\"logo_grid_padding_top_responsive\";s:0:\"\";s:23:\"logo_grid_padding_right\";s:1:\"0\";s:30:\"logo_grid_padding_right_medium\";s:0:\"\";s:34:\"logo_grid_padding_right_responsive\";s:0:\"\";s:24:\"logo_grid_padding_bottom\";s:1:\"0\";s:31:\"logo_grid_padding_bottom_medium\";s:0:\"\";s:35:\"logo_grid_padding_bottom_responsive\";s:0:\"\";s:22:\"logo_grid_padding_left\";s:1:\"0\";s:29:\"logo_grid_padding_left_medium\";s:0:\"\";s:33:\"logo_grid_padding_left_responsive\";s:0:\"\";s:27:\"logo_grid_arrow_padding_top\";s:1:\"0\";s:34:\"logo_grid_arrow_padding_top_medium\";s:0:\"\";s:38:\"logo_grid_arrow_padding_top_responsive\";s:0:\"\";s:29:\"logo_grid_arrow_padding_right\";s:1:\"0\";s:36:\"logo_grid_arrow_padding_right_medium\";s:0:\"\";s:40:\"logo_grid_arrow_padding_right_responsive\";s:0:\"\";s:30:\"logo_grid_arrow_padding_bottom\";s:1:\"0\";s:37:\"logo_grid_arrow_padding_bottom_medium\";s:0:\"\";s:41:\"logo_grid_arrow_padding_bottom_responsive\";s:0:\"\";s:28:\"logo_grid_arrow_padding_left\";s:1:\"0\";s:35:\"logo_grid_arrow_padding_left_medium\";s:0:\"\";s:39:\"logo_grid_arrow_padding_left_responsive\";s:0:\"\";s:10:\"margin_top\";s:3:\"-80\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:13:\"pp-logos-grid\";s:17:\"logo_grid_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:23:\"logo_grid_arrow_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}}}}");
INSERT INTO `wptj_postmeta` VALUES("21", "5", "_fl_builder_data_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("14", "7", "_wp_attached_file", "2019/05/crismoe_slider.jpg");
INSERT INTO `wptj_postmeta` VALUES("15", "7", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2355;s:6:\"height\";i:800;s:4:\"file\";s:26:\"2019/05/crismoe_slider.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"crismoe_slider-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"crismoe_slider-300x102.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:102;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"crismoe_slider-768x261.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:261;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"crismoe_slider-1024x348.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:348;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("16", "8", "_wp_attached_file", "2019/05/la_fonte_slider.jpg");
INSERT INTO `wptj_postmeta` VALUES("17", "8", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2355;s:6:\"height\";i:800;s:4:\"file\";s:27:\"2019/05/la_fonte_slider.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"la_fonte_slider-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"la_fonte_slider-300x102.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:102;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"la_fonte_slider-768x261.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:261;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"la_fonte_slider-1024x348.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:348;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("18", "9", "_wp_attached_file", "2019/05/reflorestamento_slider.jpg");
INSERT INTO `wptj_postmeta` VALUES("19", "9", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2355;s:6:\"height\";i:800;s:4:\"file\";s:34:\"2019/05/reflorestamento_slider.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"reflorestamento_slider-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"reflorestamento_slider-300x102.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:102;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"reflorestamento_slider-768x261.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:261;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"reflorestamento_slider-1024x348.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:348;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("22", "5", "_fl_builder_enabled", "1");
INSERT INTO `wptj_postmeta` VALUES("23", "10", "_fl_builder_data", "a:4:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:500;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"0\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}}");
INSERT INTO `wptj_postmeta` VALUES("24", "10", "_fl_builder_data_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("25", "11", "_fl_builder_data", "a:4:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:500;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"0\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}}");
INSERT INTO `wptj_postmeta` VALUES("26", "11", "_fl_builder_data_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("27", "12", "_wp_attached_file", "2019/05/acessorios_banheiro.jpg");
INSERT INTO `wptj_postmeta` VALUES("28", "12", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:421;s:4:\"file\";s:31:\"2019/05/acessorios_banheiro.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"acessorios_banheiro-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"acessorios_banheiro-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("29", "13", "_wp_attached_file", "2019/05/color-vermelho.jpg");
INSERT INTO `wptj_postmeta` VALUES("30", "13", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:480;s:4:\"file\";s:26:\"2019/05/color-vermelho.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"color-vermelho-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"color-vermelho-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"color-vermelho-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("31", "14", "_wp_attached_file", "2019/05/fechaduras.jpg");
INSERT INTO `wptj_postmeta` VALUES("32", "14", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:404;s:6:\"height\";i:291;s:4:\"file\";s:22:\"2019/05/fechaduras.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"fechaduras-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"fechaduras-300x216.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("33", "15", "_wp_attached_file", "2019/05/mdf.jpg");
INSERT INTO `wptj_postmeta` VALUES("34", "15", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:675;s:4:\"file\";s:15:\"2019/05/mdf.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"mdf-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"mdf-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"mdf-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"DSC-W170\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1210762286\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.076923076923077\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("35", "16", "_fl_builder_data", "a:28:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:500;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"1\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:1:\"0\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:1:\"0\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:1:\"0\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:1:\"0\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}s:13:\"5ce5db10a9afe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10a9afe\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10aba08\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10aba08\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5db10a9afe\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5db10abb8b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abb8b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbd4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbd4\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbf0\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbf0\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abc34\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abc34\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db1e2fa6f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db1e2fa6f\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abc34\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:268:\"<strong>Acabamento para porta</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567921952_text\";s:0:\"\";}}s:13:\"5ce5db92a4e57\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db92a4e57\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbf0\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:273:\"<strong>Conservação da fechadura</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567901621_text\";s:0:\"\";}}s:13:\"5ce5db93e98f2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db93e98f2\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abb8b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:263:\"<strong>Tipo de Madeiras</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";}}s:13:\"5ce5db94ba6cc\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db94ba6cc\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbd4\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:262:\"<strong>Reflorestamento</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567884328_text\";s:0:\"\";}}s:13:\"5ce5dbf98144f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98144f\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:3:\"-20\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985618\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985618\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dbf98579b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98579b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf9857dd\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf9857dd\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf98581b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98581b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985857\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985857\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4370\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4370\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dc1dd45fe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd45fe\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"21.51\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4651\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4651\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"78.49\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc2598f0e\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc2598f0e\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dc1dd45fe\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:63:\"<span style=\"font-size: 22px;\"><strong>Produtos</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";}}s:13:\"5ce5dc596d8e9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc596d8e9\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf985857\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"12\";s:9:\"photo_src\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:12;s:5:\"title\";s:19:\"acessorios_banheiro\";s:8:\"filename\";s:23:\"acessorios_banheiro.jpg\";s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:4:\"link\";s:56:\"https://siterapidofacil.com/dmk/dmk/acessorios_banheiro/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:19:\"acessorios_banheiro\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568064000;s:8:\"modified\";i:1558568064000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"014c5e5519\";s:6:\"delete\";s:10:\"9dd578d334\";s:4:\"edit\";s:10:\"87b4778bfc\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=12&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:58232;s:21:\"filesizeHumanReadable\";s:5:\"57 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:197;s:5:\"width\";i:300;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-300x197.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9d35876\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9d35876\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98579b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"15\";s:9:\"photo_src\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:15;s:5:\"title\";s:3:\"mdf\";s:8:\"filename\";s:7:\"mdf.jpg\";s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:4:\"link\";s:40:\"https://siterapidofacil.com/dmk/dmk/mdf/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:3:\"mdf\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568070000;s:8:\"modified\";i:1558568070000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"995e7bf2fd\";s:6:\"delete\";s:10:\"5e15dcab89\";s:4:\"edit\";s:10:\"bd4556d6ba\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=15&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:103831;s:21:\"filesizeHumanReadable\";s:6:\"101 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:225;s:5:\"width\";i:300;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-300x225.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9ed8274\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9ed8274\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98581b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"13\";s:9:\"photo_src\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:13;s:5:\"title\";s:14:\"color-vermelho\";s:8:\"filename\";s:18:\"color-vermelho.jpg\";s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:4:\"link\";s:51:\"https://siterapidofacil.com/dmk/dmk/color-vermelho/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:14:\"color-vermelho\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568065000;s:8:\"modified\";i:1558568065000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"2482326a68\";s:6:\"delete\";s:10:\"2fe426a475\";s:4:\"edit\";s:10:\"7b33315df1\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=13&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:62906;s:21:\"filesizeHumanReadable\";s:5:\"61 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:185;s:5:\"width\";i:300;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-300x185.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dca6db0ff\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dca6db0ff\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf9857dd\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"14\";s:9:\"photo_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:14;s:5:\"title\";s:10:\"fechaduras\";s:8:\"filename\";s:14:\"fechaduras.jpg\";s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:4:\"link\";s:47:\"https://siterapidofacil.com/dmk/dmk/fechaduras/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:10:\"fechaduras\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568068000;s:8:\"modified\";i:1558568068000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"17d820d0f3\";s:6:\"delete\";s:10:\"f38f1498e7\";s:4:\"edit\";s:10:\"1ccd950b23\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=14&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:26907;s:21:\"filesizeHumanReadable\";s:5:\"26 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:216;s:5:\"width\";i:300;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-300x216.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}}");
INSERT INTO `wptj_postmeta` VALUES("36", "16", "_fl_builder_data_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("37", "17", "_wp_attached_file", "2019/05/concrem.jpg");
INSERT INTO `wptj_postmeta` VALUES("38", "17", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:19:\"2019/05/concrem.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"concrem-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("39", "18", "_wp_attached_file", "2019/05/crismoe.jpg");
INSERT INTO `wptj_postmeta` VALUES("40", "18", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:19:\"2019/05/crismoe.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"crismoe-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("41", "19", "_wp_attached_file", "2019/05/la_fonte.jpg");
INSERT INTO `wptj_postmeta` VALUES("42", "19", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:20:\"2019/05/la_fonte.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"la_fonte-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("43", "20", "_wp_attached_file", "2019/05/rocha.jpg");
INSERT INTO `wptj_postmeta` VALUES("44", "20", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:17:\"2019/05/rocha.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"rocha-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("45", "21", "_wp_attached_file", "2019/05/schindwein.jpg");
INSERT INTO `wptj_postmeta` VALUES("46", "21", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:22:\"2019/05/schindwein.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"schindwein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("47", "22", "_wp_attached_file", "2019/05/VW.jpg");
INSERT INTO `wptj_postmeta` VALUES("48", "22", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:291;s:6:\"height\";i:193;s:4:\"file\";s:14:\"2019/05/VW.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"VW-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wptj_postmeta` VALUES("49", "23", "_fl_builder_data", "a:36:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:500;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"1\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:1:\"0\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:1:\"0\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:1:\"0\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:1:\"0\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}s:13:\"5ce5db10a9afe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10a9afe\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10aba08\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10aba08\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5db10a9afe\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5db10abb8b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abb8b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbd4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbd4\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbf0\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbf0\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abc34\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abc34\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db1e2fa6f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db1e2fa6f\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abc34\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:268:\"<strong>Acabamento para porta</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567921952_text\";s:0:\"\";}}s:13:\"5ce5db92a4e57\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db92a4e57\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbf0\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:273:\"<strong>Conservação da fechadura</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567901621_text\";s:0:\"\";}}s:13:\"5ce5db93e98f2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db93e98f2\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abb8b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:263:\"<strong>Tipo de Madeiras</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";}}s:13:\"5ce5db94ba6cc\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db94ba6cc\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbd4\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:262:\"<strong>Reflorestamento</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567884328_text\";s:0:\"\";}}s:13:\"5ce5dbf98144f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98144f\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:3:\"-20\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985618\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985618\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dbf98579b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98579b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf9857dd\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf9857dd\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf98581b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98581b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985857\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985857\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4370\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4370\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dc1dd45fe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd45fe\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"21.51\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4651\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4651\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"78.49\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc2598f0e\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc2598f0e\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dc1dd45fe\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:63:\"<span style=\"font-size: 22px;\"><strong>Produtos</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";}}s:13:\"5ce5dc596d8e9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc596d8e9\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf985857\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"12\";s:9:\"photo_src\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:12;s:5:\"title\";s:19:\"acessorios_banheiro\";s:8:\"filename\";s:23:\"acessorios_banheiro.jpg\";s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:4:\"link\";s:56:\"https://siterapidofacil.com/dmk/dmk/acessorios_banheiro/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:19:\"acessorios_banheiro\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568064000;s:8:\"modified\";i:1558568064000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"014c5e5519\";s:6:\"delete\";s:10:\"9dd578d334\";s:4:\"edit\";s:10:\"87b4778bfc\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=12&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:58232;s:21:\"filesizeHumanReadable\";s:5:\"57 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:197;s:5:\"width\";i:300;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-300x197.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9d35876\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9d35876\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98579b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"15\";s:9:\"photo_src\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:15;s:5:\"title\";s:3:\"mdf\";s:8:\"filename\";s:7:\"mdf.jpg\";s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:4:\"link\";s:40:\"https://siterapidofacil.com/dmk/dmk/mdf/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:3:\"mdf\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568070000;s:8:\"modified\";i:1558568070000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"995e7bf2fd\";s:6:\"delete\";s:10:\"5e15dcab89\";s:4:\"edit\";s:10:\"bd4556d6ba\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=15&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:103831;s:21:\"filesizeHumanReadable\";s:6:\"101 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:225;s:5:\"width\";i:300;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-300x225.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9ed8274\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9ed8274\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98581b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"13\";s:9:\"photo_src\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:13;s:5:\"title\";s:14:\"color-vermelho\";s:8:\"filename\";s:18:\"color-vermelho.jpg\";s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:4:\"link\";s:51:\"https://siterapidofacil.com/dmk/dmk/color-vermelho/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:14:\"color-vermelho\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568065000;s:8:\"modified\";i:1558568065000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"2482326a68\";s:6:\"delete\";s:10:\"2fe426a475\";s:4:\"edit\";s:10:\"7b33315df1\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=13&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:62906;s:21:\"filesizeHumanReadable\";s:5:\"61 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:185;s:5:\"width\";i:300;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-300x185.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dca6db0ff\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dca6db0ff\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf9857dd\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"14\";s:9:\"photo_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:14;s:5:\"title\";s:10:\"fechaduras\";s:8:\"filename\";s:14:\"fechaduras.jpg\";s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:4:\"link\";s:47:\"https://siterapidofacil.com/dmk/dmk/fechaduras/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:10:\"fechaduras\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568068000;s:8:\"modified\";i:1558568068000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"17d820d0f3\";s:6:\"delete\";s:10:\"f38f1498e7\";s:4:\"edit\";s:10:\"1ccd950b23\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=14&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:26907;s:21:\"filesizeHumanReadable\";s:5:\"26 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:216;s:5:\"width\";i:300;s:3:\"url\";s:81:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras-300x216.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:6:\"height\";i:291;s:5:\"width\";i:404;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5ddc8298a4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddc8298a4\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5ddd7e91d8\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:64:\"<span style=\"font-size: 22px;\"><strong>Parceiros</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";s:24:\"flrich1558568460929_text\";s:0:\"\";}}s:13:\"5ce5ddd7ac3c9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7ac3c9\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7d2147\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7d2147\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5ddd7e91d8\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e91d8\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5ddd7e92a2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5ddd7e92a2\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5ddd7d2147\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:50;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdd70\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdd70\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5ddd7ac3c9\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5de7ebdeba\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdeba\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5de7ebdd70\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5de7ebdc88\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5de7ebdc88\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5de7ebdeba\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":109:{s:12:\"logos_layout\";s:8:\"carousel\";s:18:\"logos_grid_spacing\";s:1:\"5\";s:22:\"logos_carousel_spacing\";s:2:\"15\";s:22:\"upload_logo_show_title\";s:4:\"none\";s:23:\"upload_logo_link_target\";s:5:\"_self\";s:12:\"equal_height\";s:3:\"yes\";s:18:\"logos_grid_columns\";s:1:\"6\";s:25:\"logos_grid_columns_medium\";s:0:\"\";s:29:\"logos_grid_columns_responsive\";s:0:\"\";s:10:\"logos_grid\";a:6:{i:0;O:8:\"stdClass\":7:{s:16:\"upload_logo_grid\";s:2:\"18\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe.jpg\";s:17:\"upload_logo_title\";s:1:\"1\";s:16:\"upload_logo_link\";s:0:\"\";s:1:\"0\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"20\";s:20:\"upload_logo_grid_src\";s:68:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/rocha.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:2;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"19\";s:20:\"upload_logo_grid_src\";s:71:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:3;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"22\";s:20:\"upload_logo_grid_src\";s:65:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/VW.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:4;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"21\";s:20:\"upload_logo_grid_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/schindwein.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}i:5;O:8:\"stdClass\":6:{s:16:\"upload_logo_grid\";s:2:\"17\";s:20:\"upload_logo_grid_src\";s:70:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/concrem.jpg\";s:17:\"upload_logo_title\";s:0:\"\";s:16:\"upload_logo_link\";s:0:\"\";s:23:\"upload_logo_link-search\";s:0:\"\";s:33:\"as_values_upload_logo_link-search\";s:0:\"\";}}s:19:\"logo_carousel_width\";s:3:\"250\";s:26:\"logo_carousel_minimum_grid\";s:1:\"6\";s:24:\"logo_carousel_move_slide\";s:0:\"\";s:21:\"logo_slider_auto_play\";s:1:\"1\";s:23:\"logo_slider_pause_hover\";s:5:\"false\";s:17:\"logo_slider_pause\";s:1:\"4\";s:22:\"logo_slider_transition\";s:10:\"horizontal\";s:17:\"logo_slider_speed\";s:3:\"0.5\";s:18:\"logo_slider_arrows\";s:1:\"0\";s:16:\"logo_slider_dots\";s:1:\"0\";s:18:\"logo_grid_bg_color\";s:0:\"\";s:18:\"logo_grid_bg_hover\";s:0:\"\";s:17:\"field_separator_1\";s:0:\"\";s:17:\"logo_grid_opacity\";s:3:\"100\";s:23:\"logo_grid_opacity_hover\";s:3:\"100\";s:17:\"field_separator_2\";s:0:\"\";s:16:\"logo_grid_border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:23:\"logo_grid_border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:27:\"logo_grid_border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"field_separator_3\";s:0:\"\";s:19:\"logo_grid_grayscale\";s:8:\"original\";s:25:\"logo_grid_grayscale_hover\";s:8:\"original\";s:27:\"logo_grid_logo_border_style\";s:4:\"none\";s:27:\"logo_grid_logo_border_width\";s:1:\"1\";s:27:\"logo_grid_logo_border_color\";s:0:\"\";s:27:\"logo_grid_logo_border_hover\";s:0:\"\";s:28:\"logo_grid_logo_border_radius\";s:1:\"0\";s:14:\"logo_grid_size\";s:0:\"\";s:26:\"logo_slider_arrow_bg_color\";s:6:\"000000\";s:23:\"logo_slider_arrow_color\";s:6:\"ffffff\";s:29:\"logo_slider_arrow_color_hover\";s:6:\"999999\";s:26:\"logo_slider_arrow_bg_hover\";s:0:\"\";s:25:\"logo_grid_arrow_font_size\";s:2:\"16\";s:32:\"logo_grid_arrow_font_size_medium\";s:0:\"\";s:36:\"logo_grid_arrow_font_size_responsive\";s:0:\"\";s:15:\"logo_grid_arrow\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:22:\"logo_grid_arrow_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:26:\"logo_grid_arrow_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:28:\"logo_grid_arrow_border_hover\";s:0:\"\";s:22:\"logo_grid_dot_bg_color\";s:6:\"f5f5f5\";s:22:\"logo_grid_dot_bg_hover\";s:6:\"999999\";s:19:\"logo_grid_dot_width\";s:2:\"14\";s:27:\"logo_grid_dot_border_radius\";s:3:\"100\";s:16:\"title_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:23:\"title_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:27:\"title_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"logo_grid_title_color\";s:6:\"000000\";s:21:\"logo_grid_title_hover\";s:6:\"666666\";s:26:\"logo_grid_title_top_margin\";s:2:\"10\";s:29:\"logo_grid_title_bottom_margin\";s:2:\"10\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:21:\"logo_grid_padding_top\";s:1:\"0\";s:28:\"logo_grid_padding_top_medium\";s:0:\"\";s:32:\"logo_grid_padding_top_responsive\";s:0:\"\";s:23:\"logo_grid_padding_right\";s:1:\"0\";s:30:\"logo_grid_padding_right_medium\";s:0:\"\";s:34:\"logo_grid_padding_right_responsive\";s:0:\"\";s:24:\"logo_grid_padding_bottom\";s:1:\"0\";s:31:\"logo_grid_padding_bottom_medium\";s:0:\"\";s:35:\"logo_grid_padding_bottom_responsive\";s:0:\"\";s:22:\"logo_grid_padding_left\";s:1:\"0\";s:29:\"logo_grid_padding_left_medium\";s:0:\"\";s:33:\"logo_grid_padding_left_responsive\";s:0:\"\";s:27:\"logo_grid_arrow_padding_top\";s:1:\"0\";s:34:\"logo_grid_arrow_padding_top_medium\";s:0:\"\";s:38:\"logo_grid_arrow_padding_top_responsive\";s:0:\"\";s:29:\"logo_grid_arrow_padding_right\";s:1:\"0\";s:36:\"logo_grid_arrow_padding_right_medium\";s:0:\"\";s:40:\"logo_grid_arrow_padding_right_responsive\";s:0:\"\";s:30:\"logo_grid_arrow_padding_bottom\";s:1:\"0\";s:37:\"logo_grid_arrow_padding_bottom_medium\";s:0:\"\";s:41:\"logo_grid_arrow_padding_bottom_responsive\";s:0:\"\";s:28:\"logo_grid_arrow_padding_left\";s:1:\"0\";s:35:\"logo_grid_arrow_padding_left_medium\";s:0:\"\";s:39:\"logo_grid_arrow_padding_left_responsive\";s:0:\"\";s:10:\"margin_top\";s:3:\"-80\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:13:\"pp-logos-grid\";s:17:\"logo_grid_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:23:\"logo_grid_arrow_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}}}}");
INSERT INTO `wptj_postmeta` VALUES("50", "23", "_fl_builder_data_settings", "O:8:\"stdClass\":2:{s:3:\"css\";s:0:\"\";s:2:\"js\";s:0:\"\";}");
INSERT INTO `wptj_postmeta` VALUES("51", "24", "_fl_builder_data", "a:36:{s:13:\"5ce5d7cdc9443\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc9443\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:4:\"full\";s:13:\"content_width\";s:4:\"full\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:1:\"0\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:1:\"0\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:1:\"0\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdca534\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca534\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5d7cdc9443\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5d7cdca6af\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdca6af\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5d7cdca534\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:100;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5d7cdc91f1\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5d7cdc91f1\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5d7cdca6af\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":58:{s:6:\"source\";s:9:\"wordpress\";s:6:\"photos\";a:3:{i:0;i:7;i:1;i:8;i:2;i:9;}s:8:\"feed_url\";s:0:\"\";s:6:\"height\";i:400;s:5:\"color\";s:5:\"light\";s:4:\"crop\";s:1:\"1\";s:7:\"protect\";s:4:\"true\";s:12:\"click_action\";s:4:\"none\";s:16:\"click_action_url\";s:0:\"\";s:9:\"auto_play\";s:4:\"true\";s:5:\"speed\";s:1:\"3\";s:10:\"transition\";s:4:\"fade\";s:18:\"transitionDuration\";s:1:\"1\";s:9:\"randomize\";s:5:\"false\";s:9:\"image_nav\";s:4:\"true\";s:8:\"nav_type\";s:4:\"none\";s:12:\"nav_position\";s:6:\"bottom\";s:13:\"arrow_buttons\";s:1:\"1\";s:11:\"play_button\";s:1:\"1\";s:9:\"fs_button\";s:1:\"1\";s:5:\"count\";s:1:\"1\";s:13:\"thumbs_button\";s:1:\"1\";s:14:\"caption_button\";s:1:\"1\";s:13:\"social_button\";s:1:\"1\";s:11:\"nav_overlay\";s:1:\"0\";s:12:\"overlay_hide\";s:4:\"true\";s:18:\"overlay_hide_delay\";s:1:\"3\";s:11:\"thumbs_size\";i:50;s:8:\"facebook\";s:4:\"true\";s:7:\"twitter\";s:4:\"true\";s:6:\"google\";s:4:\"true\";s:9:\"pinterest\";s:4:\"true\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:1:\"0\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:1:\"0\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:1:\"0\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:1:\"0\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"slideshow\";s:10:\"photo_data\";a:3:{i:7;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider.jpg\";s:8:\"thumbURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/crismoe_slider-150x150.jpg\";}i:8;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:87:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:78:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider.jpg\";s:8:\"thumbURL\";s:86:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/la_fonte_slider-150x150.jpg\";}i:9;O:8:\"stdClass\":4:{s:7:\"caption\";s:0:\"\";s:8:\"largeURL\";s:94:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-1024x348.jpg\";s:10:\"x3largeURL\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider.jpg\";s:8:\"thumbURL\";s:93:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/reflorestamento_slider-150x150.jpg\";}}s:23:\"click_action_url-search\";s:0:\"\";s:33:\"as_values_click_action_url-search\";s:0:\"\";}}s:13:\"5ce5db10a9afe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10a9afe\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:4:\"fast\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";s:0:\"\";s:18:\"top_edge_transform\";s:0:\"\";s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";s:0:\"\";s:21:\"bottom_edge_transform\";s:0:\"\";s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";i:100;s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";i:500;s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";i:400;}s:18:\"er_title_font_size\";i:18;s:13:\"er_title_case\";s:7:\"default\";s:14:\"er_title_color\";s:0:\"\";s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";i:0;s:5:\"right\";i:0;}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";i:12;s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";s:0:\"\";s:11:\"er_arrow_bg\";s:0:\"\";s:15:\"er_arrow_border\";i:0;s:21:\"er_arrow_border_color\";s:0:\"\";s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:15:\"er_arrow_radius\";i:0;s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";i:1;s:16:\"er_title_padding\";a:2:{s:3:\"top\";i:18;s:6:\"bottom\";i:18;}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";i:500;s:13:\"da_top_offset\";i:0;s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";i:0;s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";i:0;s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:30;}s:15:\"da_arrow_radius\";i:0;s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10aba08\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10aba08\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5db10a9afe\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5db10abb8b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abb8b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbd4\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbd4\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abbf0\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abbf0\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db10abc34\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db10abc34\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5db10aba08\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5db1e2fa6f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db1e2fa6f\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abc34\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:268:\"<strong>Acabamento para porta</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567921952_text\";s:0:\"\";}}s:13:\"5ce5db92a4e57\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db92a4e57\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbf0\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:273:\"<strong>Conservação da fechadura</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567901621_text\";s:0:\"\";}}s:13:\"5ce5db93e98f2\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db93e98f2\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abb8b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:263:\"<strong>Tipo de Madeiras</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";}}s:13:\"5ce5db94ba6cc\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5db94ba6cc\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5db10abbd4\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":30:{s:4:\"text\";s:262:\"<strong>Reflorestamento</strong>\n\nTexto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para ilustra um texto real quando o site estiver em prdocuação Texto de exemplo para Texto de exemplo para ilustra um texto rea\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558567751828_text\";s:0:\"\";s:24:\"flrich1558567884328_text\";s:0:\"\";}}s:13:\"5ce5dbf98144f\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98144f\";s:4:\"type\";s:3:\"row\";s:6:\"parent\";N;s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":210:{s:5:\"width\";s:5:\"fixed\";s:13:\"content_width\";s:5:\"fixed\";s:17:\"max_content_width\";s:0:\"\";s:22:\"max_content_width_unit\";s:2:\"px\";s:11:\"full_height\";s:7:\"default\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:17:\"content_alignment\";s:6:\"center\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:4:\"none\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_video_source\";s:9:\"wordpress\";s:8:\"bg_video\";s:0:\"\";s:13:\"bg_video_webm\";s:0:\"\";s:16:\"bg_video_url_mp4\";s:0:\"\";s:17:\"bg_video_url_webm\";s:0:\"\";s:20:\"bg_video_service_url\";s:0:\"\";s:14:\"bg_video_audio\";s:2:\"no\";s:17:\"bg_video_fallback\";s:0:\"\";s:21:\"bg_video_fallback_src\";s:0:\"\";s:9:\"ss_source\";s:9:\"wordpress\";s:9:\"ss_photos\";s:0:\"\";s:11:\"ss_feed_url\";s:0:\"\";s:8:\"ss_speed\";s:1:\"3\";s:13:\"ss_transition\";s:4:\"fade\";s:21:\"ss_transitionDuration\";s:1:\"1\";s:12:\"ss_randomize\";s:5:\"false\";s:17:\"bg_parallax_image\";s:0:\"\";s:21:\"bg_parallax_image_src\";s:0:\"\";s:17:\"bg_parallax_speed\";s:1:\"2\";s:15:\"bg_overlay_type\";s:5:\"color\";s:19:\"bg_overlay_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"pp_bg_overlay_type\";s:10:\"full_width\";s:16:\"bg_overlay_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:14:\"top_edge_shape\";s:0:\"\";s:14:\"top_edge_align\";s:10:\"top center\";s:19:\"top_edge_fill_style\";s:5:\"color\";s:19:\"top_edge_fill_color\";s:3:\"aaa\";s:26:\"top_edge_fill_color_medium\";s:0:\"\";s:30:\"top_edge_fill_color_responsive\";s:0:\"\";s:22:\"top_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:18:\"top_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:17:\"bottom_edge_shape\";s:0:\"\";s:17:\"bottom_edge_align\";s:13:\"bottom center\";s:22:\"bottom_edge_fill_style\";s:5:\"color\";s:22:\"bottom_edge_fill_color\";s:3:\"aaa\";s:29:\"bottom_edge_fill_color_medium\";s:0:\"\";s:33:\"bottom_edge_fill_color_responsive\";s:0:\"\";s:25:\"bottom_edge_fill_gradient\";a:5:{s:4:\"type\";s:6:\"linear\";s:5:\"angle\";s:2:\"90\";s:8:\"position\";s:13:\"center center\";s:6:\"colors\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:5:\"stops\";a:2:{i:0;s:1:\"0\";i:1;s:3:\"100\";}}s:21:\"bottom_edge_transform\";a:7:{s:10:\"scaleXSign\";s:0:\"\";s:10:\"scaleYSign\";s:0:\"\";s:5:\"skewX\";s:0:\"\";s:5:\"skewY\";s:0:\"\";s:6:\"scaleX\";s:1:\"1\";s:6:\"rotate\";s:0:\"\";s:6:\"scaleY\";s:1:\"1\";}s:18:\"container_overflow\";s:0:\"\";s:22:\"uabb_row_gradient_type\";s:6:\"linear\";s:31:\"uabb_row_gradient_primary_color\";s:0:\"\";s:33:\"uabb_row_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_row_radial_direction\";s:13:\"center_center\";s:23:\"uabb_row_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_row_linear_direction\";s:2:\"90\";s:31:\"uabb_row_linear_advance_options\";s:2:\"no\";s:36:\"uabb_row_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_row_radial_advance_options\";s:2:\"no\";s:36:\"uabb_row_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_row_radial_gradient_secondary_loc\";s:3:\"100\";s:15:\"separator_shape\";s:4:\"none\";s:21:\"separator_shape_width\";s:3:\"100\";s:28:\"separator_shape_width_medium\";s:3:\"100\";s:32:\"separator_shape_width_responsive\";s:0:\"\";s:22:\"separator_shape_height\";s:2:\"60\";s:29:\"separator_shape_height_medium\";s:0:\"\";s:33:\"separator_shape_height_responsive\";s:0:\"\";s:24:\"uabb_row_separator_color\";s:0:\"\";s:28:\"uabb_row_separator_color_opc\";s:3:\"100\";s:26:\"uabb_row_separator_z_index\";s:3:\"yes\";s:19:\"bot_separator_shape\";s:4:\"none\";s:25:\"bot_separator_shape_width\";s:3:\"100\";s:32:\"bot_separator_shape_width_medium\";s:3:\"100\";s:36:\"bot_separator_shape_width_responsive\";s:0:\"\";s:26:\"bot_separator_shape_height\";s:2:\"60\";s:33:\"bot_separator_shape_height_medium\";s:0:\"\";s:37:\"bot_separator_shape_height_responsive\";s:0:\"\";s:19:\"bot_separator_color\";s:0:\"\";s:23:\"bot_separator_color_opc\";s:3:\"100\";s:21:\"bot_separator_z_index\";s:3:\"yes\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:4:\"none\";s:15:\"separator_color\";s:6:\"ffffff\";s:16:\"separator_shadow\";s:6:\"f4f4f4\";s:16:\"separator_height\";s:3:\"100\";s:18:\"separator_position\";s:3:\"top\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:21:\"separator_type_bottom\";s:4:\"none\";s:22:\"separator_color_bottom\";s:6:\"ffffff\";s:23:\"separator_shadow_bottom\";s:6:\"f4f4f4\";s:23:\"separator_height_bottom\";s:3:\"100\";s:23:\"separator_tablet_bottom\";s:2:\"no\";s:30:\"separator_height_tablet_bottom\";s:0:\"\";s:23:\"separator_mobile_bottom\";s:2:\"no\";s:30:\"separator_height_mobile_bottom\";s:0:\"\";s:17:\"enable_expandable\";s:2:\"no\";s:8:\"er_title\";s:29:\"Click here to expand this row\";s:10:\"er_title_e\";s:31:\"Click here to collapse this row\";s:19:\"er_transition_speed\";s:3:\"500\";s:16:\"er_default_state\";s:9:\"collapsed\";s:13:\"er_title_font\";a:2:{s:6:\"family\";s:7:\"Default\";s:6:\"weight\";s:3:\"400\";}s:18:\"er_title_font_size\";s:2:\"18\";s:13:\"er_title_case\";s:4:\"none\";s:14:\"er_title_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_title_margin\";a:2:{s:6:\"bottom\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:12:\"er_arrow_pos\";s:6:\"bottom\";s:13:\"er_arrow_size\";s:2:\"12\";s:15:\"er_arrow_weight\";s:4:\"bold\";s:14:\"er_arrow_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:11:\"er_arrow_bg\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:15:\"er_arrow_border\";s:1:\"0\";s:21:\"er_arrow_border_color\";a:2:{s:7:\"primary\";s:0:\"\";s:9:\"secondary\";s:0:\"\";}s:20:\"er_arrow_padding_all\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:15:\"er_arrow_radius\";s:1:\"0\";s:11:\"er_bg_color\";s:0:\"\";s:13:\"er_bg_opacity\";s:1:\"1\";s:16:\"er_title_padding\";a:2:{s:3:\"top\";s:2:\"18\";s:6:\"bottom\";s:2:\"18\";}s:17:\"enable_down_arrow\";s:2:\"no\";s:19:\"da_transition_speed\";s:3:\"500\";s:13:\"da_top_offset\";s:1:\"0\";s:12:\"da_animation\";s:2:\"no\";s:14:\"da_hide_mobile\";s:2:\"no\";s:15:\"da_arrow_weight\";s:5:\"light\";s:14:\"da_arrow_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:11:\"da_arrow_bg\";a:2:{s:7:\"primary\";s:6:\"f4f4f4\";s:9:\"secondary\";s:6:\"f4f4f4\";}s:15:\"da_arrow_border\";s:1:\"0\";s:21:\"da_arrow_border_color\";a:2:{s:7:\"primary\";s:6:\"000000\";s:9:\"secondary\";s:6:\"000000\";}s:16:\"da_arrow_padding\";s:1:\"0\";s:15:\"da_arrow_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:2:\"30\";}s:15:\"da_arrow_radius\";s:1:\"0\";s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:19:\"top_edge_size_width\";s:0:\"\";s:18:\"top_edge_size_unit\";s:2:\"px\";s:20:\"top_edge_size_height\";s:0:\"\";s:17:\"top_edge_size_top\";s:0:\"\";s:22:\"bottom_edge_size_width\";s:0:\"\";s:21:\"bottom_edge_size_unit\";s:2:\"px\";s:23:\"bottom_edge_size_height\";s:0:\"\";s:20:\"bottom_edge_size_top\";s:0:\"\";s:10:\"margin_top\";s:3:\"-20\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:1:\"0\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985618\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985618\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:1;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dbf98579b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98579b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf9857dd\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf9857dd\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf98581b\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf98581b\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:2;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dbf985857\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dbf985857\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dbf985618\";s:8:\"position\";i:3;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";i:25;s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4370\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4370\";s:4:\"type\";s:12:\"column-group\";s:6:\"parent\";s:13:\"5ce5dbf98144f\";s:8:\"position\";i:0;s:8:\"settings\";s:0:\"\";}s:13:\"5ce5dc1dd45fe\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd45fe\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"21.51\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc1dd4651\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc1dd4651\";s:4:\"type\";s:6:\"column\";s:6:\"parent\";s:13:\"5ce5dc1dd4370\";s:8:\"position\";i:1;s:8:\"settings\";O:8:\"stdClass\":117:{s:4:\"size\";s:5:\"78.49\";s:11:\"size_medium\";s:0:\"\";s:15:\"size_responsive\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:15:\"min_height_unit\";s:2:\"px\";s:17:\"min_height_medium\";s:0:\"\";s:22:\"min_height_medium_unit\";s:2:\"px\";s:21:\"min_height_responsive\";s:0:\"\";s:26:\"min_height_responsive_unit\";s:2:\"px\";s:12:\"equal_height\";s:2:\"no\";s:17:\"content_alignment\";s:3:\"top\";s:10:\"text_color\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:11:\"hover_color\";s:0:\"\";s:13:\"heading_color\";s:0:\"\";s:7:\"bg_type\";s:5:\"color\";s:8:\"bg_color\";s:0:\"\";s:11:\"bg_gradient\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:12:\"bg_image_src\";s:0:\"\";s:15:\"bg_image_medium\";s:0:\"\";s:19:\"bg_image_medium_src\";s:0:\"\";s:19:\"bg_image_responsive\";s:0:\"\";s:23:\"bg_image_responsive_src\";s:0:\"\";s:9:\"bg_repeat\";s:4:\"none\";s:16:\"bg_repeat_medium\";s:0:\"\";s:20:\"bg_repeat_responsive\";s:0:\"\";s:11:\"bg_position\";s:13:\"center center\";s:18:\"bg_position_medium\";s:0:\"\";s:22:\"bg_position_responsive\";s:0:\"\";s:13:\"bg_attachment\";s:6:\"scroll\";s:20:\"bg_attachment_medium\";s:0:\"\";s:24:\"bg_attachment_responsive\";s:0:\"\";s:7:\"bg_size\";s:5:\"cover\";s:14:\"bg_size_medium\";s:0:\"\";s:18:\"bg_size_responsive\";s:0:\"\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:0:\"\";s:19:\"bg_overlay_gradient\";s:0:\"\";s:22:\"uabb_col_gradient_type\";s:6:\"linear\";s:31:\"uabb_col_gradient_primary_color\";s:0:\"\";s:33:\"uabb_col_gradient_secondary_color\";s:0:\"\";s:25:\"uabb_col_radial_direction\";s:13:\"center_center\";s:23:\"uabb_col_uabb_direction\";s:6:\"bottom\";s:25:\"uabb_col_linear_direction\";s:2:\"24\";s:31:\"uabb_col_linear_advance_options\";s:2:\"no\";s:36:\"uabb_col_linear_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_linear_gradient_secondary_loc\";s:3:\"100\";s:31:\"uabb_col_radial_advance_options\";s:2:\"no\";s:36:\"uabb_col_radial_gradient_primary_loc\";s:1:\"0\";s:38:\"uabb_col_radial_gradient_secondary_loc\";s:3:\"100\";s:6:\"border\";s:0:\"\";s:13:\"border_medium\";s:0:\"\";s:17:\"border_responsive\";s:0:\"\";s:15:\"col_drop_shadow\";s:2:\"no\";s:20:\"col_shadow_color_hor\";s:1:\"0\";s:20:\"col_shadow_color_ver\";s:1:\"0\";s:21:\"col_shadow_color_blur\";s:1:\"7\";s:20:\"col_shadow_color_spr\";s:1:\"0\";s:16:\"col_shadow_color\";s:21:\"rgba(168,168,168,0.5)\";s:16:\"col_hover_shadow\";s:2:\"no\";s:26:\"col_shadow_color_hor_hover\";s:1:\"0\";s:26:\"col_shadow_color_ver_hover\";s:1:\"0\";s:27:\"col_shadow_color_blur_hover\";s:2:\"10\";s:26:\"col_shadow_color_spr_hover\";s:1:\"1\";s:22:\"col_shadow_color_hover\";s:21:\"rgba(168,168,168,0.9)\";s:27:\"col_shadow_hover_transition\";i:200;s:21:\"col_responsive_shadow\";s:2:\"no\";s:16:\"col_small_shadow\";s:2:\"no\";s:16:\"enable_separator\";s:2:\"no\";s:14:\"separator_type\";s:0:\"\";s:15:\"separator_color\";s:6:\"ffffff\";s:17:\"separator_opacity\";i:100;s:16:\"separator_height\";i:100;s:18:\"separator_position\";s:6:\"bottom\";s:16:\"separator_tablet\";s:2:\"no\";s:23:\"separator_height_tablet\";s:0:\"\";s:16:\"separator_mobile\";s:2:\"no\";s:23:\"separator_height_mobile\";s:0:\"\";s:18:\"responsive_display\";s:0:\"\";s:16:\"responsive_order\";s:7:\"default\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";s:0:\"\";s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:11:\"padding_top\";s:0:\"\";s:12:\"padding_unit\";s:2:\"px\";s:18:\"padding_top_medium\";s:0:\"\";s:19:\"padding_medium_unit\";s:2:\"px\";s:22:\"padding_top_responsive\";s:0:\"\";s:23:\"padding_responsive_unit\";s:2:\"px\";s:13:\"padding_right\";s:0:\"\";s:20:\"padding_right_medium\";s:0:\"\";s:24:\"padding_right_responsive\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:21:\"padding_bottom_medium\";s:0:\"\";s:25:\"padding_bottom_responsive\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";s:19:\"padding_left_medium\";s:0:\"\";s:23:\"padding_left_responsive\";s:0:\"\";}}s:13:\"5ce5dc2598f0e\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc2598f0e\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dc1dd45fe\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":29:{s:4:\"text\";s:63:\"<span style=\"font-size: 22px;\"><strong>Produtos</strong></span>\";s:5:\"color\";s:0:\"\";s:10:\"typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:17:\"typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:21:\"typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:0:\"\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:9:\"rich-text\";s:24:\"flrich1558568015533_text\";s:0:\"\";}}s:13:\"5ce5dc596d8e9\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc596d8e9\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf985857\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"12\";s:9:\"photo_src\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:12;s:5:\"title\";s:19:\"acessorios_banheiro\";s:8:\"filename\";s:23:\"acessorios_banheiro.jpg\";s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:4:\"link\";s:56:\"https://siterapidofacil.com/dmk/dmk/acessorios_banheiro/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:19:\"acessorios_banheiro\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568064000;s:8:\"modified\";i:1558568064000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"014c5e5519\";s:6:\"delete\";s:10:\"9dd578d334\";s:4:\"edit\";s:10:\"87b4778bfc\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=12&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:58232;s:21:\"filesizeHumanReadable\";s:5:\"57 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:197;s:5:\"width\";i:300;s:3:\"url\";s:90:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro-300x197.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:82:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/acessorios_banheiro.jpg\";s:6:\"height\";i:421;s:5:\"width\";i:640;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9d35876\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9d35876\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98579b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"15\";s:9:\"photo_src\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:15;s:5:\"title\";s:3:\"mdf\";s:8:\"filename\";s:7:\"mdf.jpg\";s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:4:\"link\";s:40:\"https://siterapidofacil.com/dmk/dmk/mdf/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:3:\"mdf\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568070000;s:8:\"modified\";i:1558568070000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"995e7bf2fd\";s:6:\"delete\";s:10:\"5e15dcab89\";s:4:\"edit\";s:10:\"bd4556d6ba\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=15&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:103831;s:21:\"filesizeHumanReadable\";s:6:\"101 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:225;s:5:\"width\";i:300;s:3:\"url\";s:74:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf-300x225.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:66:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/mdf.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:900;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dc9ed8274\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dc9ed8274\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf98581b\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"13\";s:9:\"photo_src\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:13;s:5:\"title\";s:14:\"color-vermelho\";s:8:\"filename\";s:18:\"color-vermelho.jpg\";s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:4:\"link\";s:51:\"https://siterapidofacil.com/dmk/dmk/color-vermelho/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:14:\"color-vermelho\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568065000;s:8:\"modified\";i:1558568065000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"2482326a68\";s:6:\"delete\";s:10:\"2fe426a475\";s:4:\"edit\";s:10:\"7b33315df1\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=13&action=edit\";s:4:\"meta\";b:0;s:10:\"authorName\";s:7:\"klester\";s:14:\"uploadedToLink\";s:68:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=5&action=edit\";s:15:\"uploadedToTitle\";s:3:\"DMK\";s:15:\"filesizeInBytes\";i:62906;s:21:\"filesizeHumanReadable\";s:5:\"61 KB\";s:7:\"context\";s:0:\"\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";s:5:\"sizes\";O:8:\"stdClass\":3:{s:9:\"thumbnail\";O:8:\"stdClass\":4:{s:6:\"height\";i:150;s:5:\"width\";i:150;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-150x150.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:6:\"medium\";O:8:\"stdClass\":4:{s:6:\"height\";i:185;s:5:\"width\";i:300;s:3:\"url\";s:85:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho-300x185.jpg\";s:11:\"orientation\";s:9:\"landscape\";}s:4:\"full\";O:8:\"stdClass\":4:{s:3:\"url\";s:77:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/color-vermelho.jpg\";s:6:\"height\";i:480;s:5:\"width\";i:780;s:11:\"orientation\";s:9:\"landscape\";}}}s:15:\"link_url-search\";s:0:\"\";s:25:\"as_values_link_url-search\";s:0:\"\";}}s:13:\"5ce5dca6db0ff\";O:8:\"stdClass\":5:{s:4:\"node\";s:13:\"5ce5dca6db0ff\";s:4:\"type\";s:6:\"module\";s:6:\"parent\";s:13:\"5ce5dbf9857dd\";s:8:\"position\";i:0;s:8:\"settings\";O:8:\"stdClass\":52:{s:12:\"photo_source\";s:7:\"library\";s:5:\"photo\";s:2:\"14\";s:9:\"photo_src\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:9:\"photo_url\";s:0:\"\";s:12:\"show_caption\";s:1:\"0\";s:7:\"caption\";s:0:\"\";s:9:\"link_type\";s:0:\"\";s:8:\"link_url\";s:0:\"\";s:15:\"link_url_target\";s:5:\"_self\";s:17:\"link_url_nofollow\";s:2:\"no\";s:4:\"crop\";s:9:\"landscape\";s:5:\"width\";s:0:\"\";s:10:\"width_unit\";s:2:\"px\";s:12:\"width_medium\";s:0:\"\";s:17:\"width_medium_unit\";s:2:\"px\";s:16:\"width_responsive\";s:0:\"\";s:21:\"width_responsive_unit\";s:2:\"px\";s:5:\"align\";s:6:\"center\";s:12:\"align_medium\";s:0:\"\";s:16:\"align_responsive\";s:0:\"\";s:6:\"border\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:13:\"border_medium\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:17:\"border_responsive\";a:5:{s:5:\"style\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"radius\";a:4:{s:8:\"top_left\";s:0:\"\";s:9:\"top_right\";s:0:\"\";s:11:\"bottom_left\";s:0:\"\";s:12:\"bottom_right\";s:0:\"\";}s:6:\"shadow\";a:5:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";s:6:\"spread\";s:0:\"\";}}s:18:\"caption_typography\";a:11:{s:11:\"font_family\";s:7:\"Default\";s:11:\"font_weight\";s:7:\"default\";s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:25:\"caption_typography_medium\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:29:\"caption_typography_responsive\";a:9:{s:9:\"font_size\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"line_height\";a:2:{s:6:\"length\";s:0:\"\";s:4:\"unit\";s:0:\"\";}s:10:\"text_align\";s:0:\"\";s:14:\"letter_spacing\";a:1:{s:6:\"length\";s:0:\"\";}s:14:\"text_transform\";s:0:\"\";s:15:\"text_decoration\";s:0:\"\";s:10:\"font_style\";s:0:\"\";s:12:\"font_variant\";s:0:\"\";s:11:\"text_shadow\";a:4:{s:5:\"color\";s:0:\"\";s:10:\"horizontal\";s:0:\"\";s:8:\"vertical\";s:0:\"\";s:4:\"blur\";s:0:\"\";}}s:18:\"responsive_display\";s:0:\"\";s:18:\"visibility_display\";s:0:\"\";s:26:\"visibility_user_capability\";s:0:\"\";s:9:\"animation\";a:3:{s:5:\"style\";s:0:\"\";s:5:\"delay\";s:1:\"0\";s:8:\"duration\";s:1:\"1\";}s:17:\"container_element\";s:3:\"div\";s:2:\"id\";s:0:\"\";s:5:\"class\";s:0:\"\";s:10:\"margin_top\";s:3:\"-45\";s:11:\"margin_unit\";s:2:\"px\";s:17:\"margin_top_medium\";s:0:\"\";s:18:\"margin_medium_unit\";s:2:\"px\";s:21:\"margin_top_responsive\";s:0:\"\";s:22:\"margin_responsive_unit\";s:2:\"px\";s:12:\"margin_right\";s:0:\"\";s:19:\"margin_right_medium\";s:0:\"\";s:23:\"margin_right_responsive\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:20:\"margin_bottom_medium\";s:0:\"\";s:24:\"margin_bottom_responsive\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:18:\"margin_left_medium\";s:0:\"\";s:22:\"margin_left_responsive\";s:0:\"\";s:4:\"type\";s:5:\"photo\";s:4:\"data\";O:8:\"stdClass\":33:{s:2:\"id\";i:14;s:5:\"title\";s:10:\"fechaduras\";s:8:\"filename\";s:14:\"fechaduras.jpg\";s:3:\"url\";s:73:\"https://siterapidofacil.com/dmk/wp-content/uploads/2019/05/fechaduras.jpg\";s:4:\"link\";s:47:\"https://siterapidofacil.com/dmk/dmk/fechaduras/\";s:3:\"alt\";s:0:\"\";s:6:\"author\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:4:\"name\";s:10:\"fechaduras\";s:6:\"status\";s:7:\"inherit\";s:10:\"uploadedTo\";i:5;s:4:\"date\";i:1558568068000;s:8:\"modified\";i:1558568068000;s:9:\"menuOrder\";i:0;s:4:\"mime\";s:10:\"image/jpeg\";s:4:\"type\";s:5:\"image\";s:7:\"subtype\";s:4:\"jpeg\";s:4:\"icon\";s:68:\"https://siterapidofacil.com/dmk/wp-includes/images/media/default.png\";s:13:\"dateFormatted\";s:18:\"22 de maio de 2019\";s:6:\"nonces\";O:8:\"stdClass\":3:{s:6:\"update\";s:10:\"17d820d0f3\";s:6:\"delete\";s:10:\"f38f1498e7\";s:4:\"edit\";s:10:\"1ccd950b23\";}s:8:\"editLink\";s:69:\"https://siterapidofacil.com/dmk/wp-admin/post.php?post=14&action=edit\";s:4:\"meta\";b:0;s:10